<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('active_sessions', function (Blueprint $table) {
            // Agregar columnas sin especificar 'after' para evitar errores
            if (!Schema::hasColumn('active_sessions', 'location')) {
                $table->string('location')->nullable();
            }
            if (!Schema::hasColumn('active_sessions', 'latitude')) {
                $table->decimal('latitude', 10, 8)->nullable();
            }
            if (!Schema::hasColumn('active_sessions', 'longitude')) {
                $table->decimal('longitude', 11, 8)->nullable();
            }
            if (!Schema::hasColumn('active_sessions', 'is_active')) {
                $table->boolean('is_active')->default(true);
            }
            if (!Schema::hasColumn('active_sessions', 'login_at')) {
                $table->timestamp('login_at')->nullable();
            }
            if (!Schema::hasColumn('active_sessions', 'logout_at')) {
                $table->timestamp('logout_at')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('active_sessions', function (Blueprint $table) {
            $table->dropColumn(['location', 'latitude', 'longitude', 'is_active', 'login_at', 'logout_at']);
        });
    }
};