<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos', function (Blueprint $table) {
            $table->id();
            $table->string('fecha')->default(date('Y-m-d'));
            $table->string('total_usd');
            $table->string('total_bs');
            $table->string('codigo');
            $table->string('metodo_pago');
            $table->string('ubicacion');
            $table->string('longitud');
            $table->string('latitud');
            $table->string('estado');
            $table->foreignId('empresaId')->constrained('empresas')->onDelete('cascade');
            $table->foreignId('userId')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos');
    }
};
