<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wishlists', function (Blueprint $table) {
            $table->id();
            $table->foreignId('producto_id')
                       ->default(1)
                       ->constrained('productos')
                       ->onUpdate('cascade')
                       ->onDelete('cascade');
            $table->foreignId('user_id')
                       ->default(1)
                       ->constrained('users')
                       ->onUpdate('cascade')
                       ->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wishlists');
    }
};
