<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('producto_seo', function (Blueprint $table) {
            $table->id();
            $table->foreignId('producto_id')
                ->constrained('productos')
                ->onUpdate('cascade')
                ->onDelete('cascade')
                ->unique(); // Un producto tiene una sola configuración SEO
            $table->string('sku')->nullable();
            $table->string('barcode')->nullable();
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('tags')->nullable();
            $table->boolean('featured')->default(false);
            $table->foreignId('empresa_id')
                ->constrained('empresas')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->timestamps();

            $table->index('producto_id');
            $table->index('empresa_id');
            $table->index('sku');
            $table->index('barcode');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('producto_seo');
    }
};
