<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('producto_inventory_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('producto_id')
                ->constrained('productos')
                ->onUpdate('cascade')
                ->onDelete('cascade')
                ->unique(); // Un producto tiene una sola configuración de inventario
            $table->boolean('track_inventory')->default(true);
            $table->boolean('allow_backorder')->default(false);
            $table->string('inventory_policy')->default('deny'); // deny, allow, pre-order
            $table->integer('low_stock_threshold')->default(5);
            $table->foreignId('empresa_id')
                ->constrained('empresas')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->timestamps();

            $table->index('producto_id');
            $table->index('empresa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('producto_inventory_settings');
    }
};
