<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('productos', function (Blueprint $table) {
            $table->string('sku')->nullable()->after('code');
            $table->string('barcode')->nullable()->after('sku');
            $table->text('tags')->nullable()->after('description');
            $table->string('meta_title')->nullable()->after('tags');
            $table->text('meta_description')->nullable()->after('meta_title');
            $table->boolean('has_variants')->default(false)->after('meta_description');
            $table->boolean('track_inventory')->default(true)->after('has_variants');
            $table->boolean('featured')->default(false)->after('track_inventory');
            $table->boolean('allow_backorder')->default(false)->after('featured');
            $table->string('inventory_policy')->default('deny')->after('allow_backorder');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('productos', function (Blueprint $table) {
            $table->dropColumn([
                'sku',
                'barcode',
                'tags',
                'meta_title',
                'meta_description',
                'has_variants',
                'track_inventory',
                'featured',
                'allow_backorder',
                'inventory_policy'
            ]);
        });
    }
};
