<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('images', function (Blueprint $table) {
            $table->string('thumbnail_path')->nullable()->after('path');
            $table->string('alt_text')->nullable()->after('thumbnail_path');
            $table->boolean('is_primary')->default(false)->after('alt_text');
            $table->integer('order')->default(0)->after('is_primary');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('images', function (Blueprint $table) {
            $table->dropColumn(['thumbnail_path', 'alt_text', 'is_primary', 'order']);
        });
    }
};
