<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->after('email');
            $table->text('address')->nullable()->after('phone');
            $table->text('bio')->nullable()->after('address');
            $table->boolean('notifications_email')->default(true)->after('bio');
            $table->boolean('notifications_sms')->default(false)->after('notifications_email');
            $table->boolean('notifications_push')->default(true)->after('notifications_sms');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['phone', 'address', 'bio', 'notifications_email', 'notifications_sms', 'notifications_push']);
        });
    }
};