<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_batches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('producto_id')->constrained('productos')->onDelete('cascade');
            $table->string('batch_number');
            $table->integer('initial_quantity');
            $table->integer('current_quantity');
            $table->date('manufacturing_date');
            $table->date('expiry_date');
            $table->string('supplier')->nullable();
            $table->decimal('cost_per_unit', 10, 2)->nullable();
            $table->enum('status', ['active', 'expired', 'recalled', 'sold_out'])->default('active');
            $table->text('notes')->nullable();
            $table->foreignId('empresa_id')->constrained('empresas');
            $table->timestamps();
            
            $table->index(['producto_id', 'batch_number']);
            $table->index(['expiry_date', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_batches');
    }
};