<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mensajes_pendientes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('pedido_id')->nullable();
            $table->string('telefono');
            $table->text('mensaje');
            $table->string('tipo'); // asignacion_empleado, asignacion_cliente, etc.
            $table->text('error')->nullable();
            $table->enum('estado', ['pendiente', 'enviado', 'fallido'])->default('pendiente');
            $table->integer('intentos')->default(1);
            $table->timestamp('ultimo_intento')->nullable();
            $table->timestamp('enviado_en')->nullable();
            $table->timestamps();
            
            // Índices para búsquedas eficientes
            $table->index('pedido_id');
            $table->index('estado');
            $table->index('tipo');
            $table->index('ultimo_intento');
            
            // Relación con pedidos
            $table->foreign('pedido_id')
                ->references('id')
                ->on('pedidos')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mensajes_pendientes');
    }
};