-- Respaldo filtrado por fechas (2025-11-28 a 2025-11-28)
-- Generado: 2025-11-28 17:25:40

-- Deshabilitar verificación de llaves foráneas
SET FOREIGN_KEY_CHECKS = 0;
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;


-- Estructura de tabla `active_sessions`
DROP TABLE IF EXISTS `active_sessions`;
CREATE TABLE `active_sessions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `session_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `last_activity` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `login_at` timestamp NULL DEFAULT NULL,
  `logout_at` timestamp NULL DEFAULT NULL,
  `is_current` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `active_sessions_user_id_session_id_index` (`user_id`,`session_id`),
  CONSTRAINT `active_sessions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `active_sessions` (filtrado)
TRUNCATE TABLE `active_sessions`;
INSERT INTO `active_sessions` (`id`, `user_id`, `session_id`, `ip_address`, `user_agent`, `location`, `latitude`, `longitude`, `last_activity`, `login_at`, `logout_at`, `is_current`, `is_active`, `created_at`, `updated_at`) VALUES
('13', '2', '64I9Zcj3TbreJF8uOKeqaEcXsOVw1iLyKUtYdIoz', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, '10.43988480', '-66.86638080', '2025-11-28 09:34:59', NULL, NULL, '0', '1', '2025-11-28 09:34:59', '2025-11-28 09:34:59'),
('14', '2', 'OUyPVEl0vnicHKImEVAAvmMztayChXzCHyPG95FR', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, '10.49626500', '-66.88133550', '2025-11-28 15:40:37', NULL, NULL, '0', '1', '2025-11-28 15:40:37', '2025-11-28 15:40:37');


-- Estructura de tabla `activity_log`
DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject_id` bigint unsigned DEFAULT NULL,
  `causer_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` bigint unsigned DEFAULT NULL,
  `properties` json DEFAULT NULL,
  `batch_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject_type`,`subject_id`),
  KEY `causer` (`causer_type`,`causer_id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla activity_log: Sin datos en el rango de fechas


-- Estructura de tabla `bancos`
DROP TABLE IF EXISTS `bancos`;
CREATE TABLE `bancos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bancos_codigo_unique` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla bancos: Sin datos en el rango de fechas


-- Estructura de tabla `cache`
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cache: Sin columnas de fecha, respaldando todos los datos
-- Tabla cache: Sin datos


-- Estructura de tabla `cache_locks`
DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cache_locks: Sin columnas de fecha, respaldando todos los datos
-- Tabla cache_locks: Sin datos


-- Estructura de tabla `cajas`
DROP TABLE IF EXISTS `cajas`;
CREATE TABLE `cajas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `fecha` date NOT NULL,
  `numero_corte` int NOT NULL DEFAULT '1',
  `monto_inicial` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_efectivo` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_transferencias` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_tarjetas` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_ingresos` decimal(10,2) NOT NULL DEFAULT '0.00',
  `monto_final` decimal(10,2) NOT NULL DEFAULT '0.00',
  `estado` enum('abierta','cerrada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'abierta',
  `fecha_apertura` timestamp NOT NULL,
  `fecha_cierre` timestamp NULL DEFAULT NULL,
  `observaciones_apertura` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `observaciones_cierre` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cajas_user_id_foreign` (`user_id`),
  KEY `cajas_fecha_estado_index` (`fecha`,`estado`),
  KEY `cajas_empresa_id_foreign` (`empresa_id`),
  KEY `cajas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `cajas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cajas: Sin datos en el rango de fechas


-- Estructura de tabla `categorias`
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE `categorias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categorias_slug_unique` (`slug`),
  KEY `categorias_empresa_id_foreign` (`empresa_id`),
  KEY `categorias_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `categorias_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categorias_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla categorias: Sin datos en el rango de fechas


-- Estructura de tabla `clientes`
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombres` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `documento_identidad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clientes_empresa_id_foreign` (`empresa_id`),
  KEY `clientes_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `clientes_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla clientes: Sin datos en el rango de fechas


-- Estructura de tabla `comprobantes`
DROP TABLE IF EXISTS `comprobantes`;
CREATE TABLE `comprobantes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha_emision` datetime NOT NULL,
  `serie` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` json NOT NULL,
  `comprobanteable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobanteable_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `comprobantes_numero_unique` (`numero`),
  KEY `comprobantes_comprobanteable_type_comprobanteable_id_index` (`comprobanteable_type`,`comprobanteable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla comprobantes: Sin datos en el rango de fechas


-- Estructura de tabla `detalle_pedidos`
DROP TABLE IF EXISTS `detalle_pedidos`;
CREATE TABLE `detalle_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `productoId` bigint unsigned NOT NULL,
  `variant_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `detalle_pedidos_empresaid_foreign` (`empresaId`),
  KEY `detalle_pedidos_userid_foreign` (`userId`),
  KEY `detalle_pedidos_productoid_foreign` (`productoId`),
  KEY `detalle_pedidos_pedidoid_foreign` (`pedidoId`),
  KEY `detalle_pedidos_variant_id_foreign` (`variant_id`),
  CONSTRAINT `detalle_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_productoid_foreign` FOREIGN KEY (`productoId`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_variant_id_foreign` FOREIGN KEY (`variant_id`) REFERENCES `producto_variants` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `detalle_pedidos` (filtrado)
TRUNCATE TABLE `detalle_pedidos`;
INSERT INTO `detalle_pedidos` (`id`, `fecha`, `total_usd`, `total_bs`, `quantity`, `price`, `empresaId`, `userId`, `productoId`, `variant_id`, `product_name`, `pedidoId`, `created_at`, `updated_at`) VALUES
('15', '2025-11-28 16:51:43', '31.5', '31.5', '30', '1.05', '1', '2', '199', NULL, NULL, '7', '2025-11-28 16:51:43', '2025-11-28 16:51:43'),
('16', '2025-11-28 16:56:55', '5.4', '5.4', '2', '2.70', '1', '2', '199', NULL, NULL, '8', '2025-11-28 16:56:55', '2025-11-28 16:56:55'),
('17', '2025-11-28 16:56:55', '2.1', '2.1', '2', '1.05', '1', '2', '199', NULL, NULL, '8', '2025-11-28 16:56:55', '2025-11-28 16:56:55'),
('18', '2025-11-28 17:02:48', '2.7', '2.7', '1', '2.70', '1', '2', '199', NULL, NULL, '9', '2025-11-28 17:02:48', '2025-11-28 17:02:48'),
('19', '2025-11-28 17:02:48', '1.05', '1.05', '1', '1.05', '1', '2', '199', NULL, NULL, '9', '2025-11-28 17:02:48', '2025-11-28 17:02:48');


-- Estructura de tabla `empleado_pedido`
DROP TABLE IF EXISTS `empleado_pedido`;
CREATE TABLE `empleado_pedido` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empleadoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleado_pedido_empleadoid_pedidoid_unique` (`empleadoId`,`pedidoId`),
  KEY `empleado_pedido_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `empleado_pedido_empleadoid_foreign` FOREIGN KEY (`empleadoId`) REFERENCES `empleados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleado_pedido_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empleado_pedido: Sin datos en el rango de fechas


-- Estructura de tabla `empleados`
DROP TABLE IF EXISTS `empleados`;
CREATE TABLE `empleados` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombres` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_documento` enum('cedula','pasaporte','rif') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('masculino','femenino','otro') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cargo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `departamento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salario` decimal(10,2) DEFAULT NULL,
  `fecha_ingreso` date NOT NULL,
  `fecha_salida` date DEFAULT NULL,
  `estado_civil` enum('soltero','casado','divorciado','viudo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contacto_emergencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono_emergencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observaciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleados_codigo_unique` (`codigo`),
  UNIQUE KEY `empleados_documento_unique` (`documento`),
  UNIQUE KEY `empleados_email_unique` (`email`),
  KEY `empleados_empresa_id_foreign` (`empresa_id`),
  KEY `empleados_sucursal_id_foreign` (`sucursal_id`),
  KEY `empleados_user_id_foreign` (`user_id`),
  CONSTRAINT `empleados_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empleados: Sin datos en el rango de fechas


-- Estructura de tabla `empresas`
DROP TABLE IF EXISTS `empresas`;
CREATE TABLE `empresas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pais_id` bigint unsigned DEFAULT NULL,
  `razon_social` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `representante_legal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empresas_documento_unique` (`documento`),
  KEY `empresas_pais_id_foreign` (`pais_id`),
  CONSTRAINT `empresas_pais_id_foreign` FOREIGN KEY (`pais_id`) REFERENCES `pais` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empresas: Sin datos en el rango de fechas


-- Estructura de tabla `exchange_rates`
DROP TABLE IF EXISTS `exchange_rates`;
CREATE TABLE `exchange_rates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `usd_rate` decimal(10,4) NOT NULL,
  `eur_rate` decimal(10,4) DEFAULT NULL,
  `source` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fetch_time` time NOT NULL,
  `raw_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exchange_rates_date_fetch_time_unique` (`date`,`fetch_time`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `exchange_rates` (filtrado)
TRUNCATE TABLE `exchange_rates`;
INSERT INTO `exchange_rates` (`id`, `date`, `usd_rate`, `eur_rate`, `source`, `fetch_time`, `raw_data`, `created_at`, `updated_at`) VALUES
('3', '2025-11-28', '245.6697', '284.8810', 'dolarvzla', '16:50:38', '{\"source\": \"dolarvzla\", \"eur_rate\": 284.88104081, \"usd_rate\": 245.6697}', '2025-11-28 16:50:38', '2025-11-28 16:50:38');


-- Estructura de tabla `failed_jobs`
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla failed_jobs: Sin datos en el rango de fechas


-- Estructura de tabla `historico_pedidos`
DROP TABLE IF EXISTS `historico_pedidos`;
CREATE TABLE `historico_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `historico_pedidos_empresaid_foreign` (`empresaId`),
  KEY `historico_pedidos_userid_foreign` (`userId`),
  KEY `historico_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `historico_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `historico_pedidos` (filtrado)
TRUNCATE TABLE `historico_pedidos`;
INSERT INTO `historico_pedidos` (`id`, `fecha`, `descripcion`, `titulo`, `empresaId`, `userId`, `pedidoId`, `created_at`, `updated_at`) VALUES
('19', '2025-11-28 16:51:43', 'El pedido #: 0008 Se ha realizado.', 'Orden creada', '1', '2', '7', '2025-11-28 16:51:43', '2025-11-28 16:51:43'),
('20', '2025-11-28 16:56:55', 'El pedido #: 0009 Se ha realizado.', 'Orden creada', '1', '2', '8', '2025-11-28 16:56:55', '2025-11-28 16:56:55'),
('21', '2025-11-28 17:02:48', 'El pedido #: 0010 Se ha realizado.', 'Orden creada', '1', '2', '9', '2025-11-28 17:02:48', '2025-11-28 17:02:48');


-- Estructura de tabla `images`
DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '0',
  `producto_id` bigint unsigned NOT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `images_producto_id_foreign` (`producto_id`),
  KEY `images_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `images_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `images_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `images` (filtrado)
TRUNCATE TABLE `images`;
INSERT INTO `images` (`id`, `path`, `thumbnail_path`, `alt_text`, `is_primary`, `order`, `producto_id`, `featured`, `empresa_id`, `created_at`, `updated_at`) VALUES
('136', 'productos/1764337416_0.jpg', NULL, NULL, '0', '0', '42', '1', '1', '2025-11-28 09:43:36', '2025-11-28 09:43:36'),
('137', 'productos/1764337767_0.jpg', NULL, NULL, '0', '0', '43', '1', '1', '2025-11-28 09:49:27', '2025-11-28 09:49:27'),
('138', 'productos/1764337943_0.jpg', NULL, NULL, '0', '0', '44', '1', '1', '2025-11-28 09:52:23', '2025-11-28 09:52:23'),
('139', 'productos/1764338134_0.jpg', NULL, NULL, '0', '0', '46', '1', '1', '2025-11-28 09:55:34', '2025-11-28 09:55:34'),
('140', 'productos/1764338160_0.jpg', NULL, NULL, '0', '0', '47', '1', '1', '2025-11-28 09:56:00', '2025-11-28 09:56:00'),
('141', 'productos/1764338245_0.jpg', NULL, NULL, '0', '0', '48', '1', '1', '2025-11-28 09:57:25', '2025-11-28 09:57:25'),
('142', 'productos/1764338349_0.webp', NULL, NULL, '0', '0', '50', '1', '1', '2025-11-28 09:59:09', '2025-11-28 09:59:09'),
('143', 'productos/1764338526_0.jpg', NULL, NULL, '0', '0', '51', '1', '1', '2025-11-28 10:02:06', '2025-11-28 10:02:06'),
('144', 'productos/i4x5dqeFlSrw5alZ3YeEuL7RZ56EKJiY4ktApYB9.jpg', NULL, 'Cigarrillos Consul', '0', '0', '272', '0', '1', '2025-11-28 10:41:40', '2025-11-28 10:41:40'),
('145', 'productos/1764340900_0.jpg', NULL, NULL, '0', '0', '272', '1', '1', '2025-11-28 10:41:40', '2025-11-28 10:41:40'),
('146', 'productos/1764341410_0.jpg', NULL, NULL, '0', '0', '273', '1', '1', '2025-11-28 10:50:10', '2025-11-28 10:50:10'),
('147', 'productos/1764342731_0.jpg', NULL, NULL, '0', '0', '60', '1', '1', '2025-11-28 11:12:11', '2025-11-28 11:12:11'),
('148', 'productos/1764343424_0.jpg', NULL, NULL, '0', '0', '61', '1', '1', '2025-11-28 11:23:44', '2025-11-28 11:23:44'),
('149', 'productos/1764343479_0.jpg', NULL, NULL, '0', '0', '63', '1', '1', '2025-11-28 11:24:39', '2025-11-28 11:24:39'),
('150', 'productos/1764343555_0.jpg', NULL, NULL, '0', '0', '59', '1', '1', '2025-11-28 11:25:55', '2025-11-28 11:25:55'),
('151', 'productos/1764343834_0.jpg', NULL, NULL, '0', '0', '58', '1', '1', '2025-11-28 11:30:34', '2025-11-28 11:30:34'),
('152', 'productos/1764344060_0.jpg', NULL, NULL, '0', '0', '66', '1', '1', '2025-11-28 11:34:21', '2025-11-28 11:34:21'),
('153', 'productos/1764345114_0.jpg', NULL, NULL, '0', '0', '200', '1', '1', '2025-11-28 11:51:54', '2025-11-28 11:51:54'),
('154', 'productos/1764345151_0.jpg', NULL, NULL, '0', '0', '201', '1', '1', '2025-11-28 11:52:31', '2025-11-28 11:52:31'),
('155', 'productos/1764345185_0.jpg', NULL, NULL, '0', '0', '202', '1', '1', '2025-11-28 11:53:05', '2025-11-28 11:53:05'),
('156', 'productos/1764345261_0.jpg', NULL, NULL, '0', '0', '185', '1', '1', '2025-11-28 11:54:21', '2025-11-28 11:54:21'),
('157', 'productos/1764345290_0.jpg', NULL, NULL, '0', '0', '186', '1', '1', '2025-11-28 11:54:50', '2025-11-28 11:54:50'),
('158', 'productos/1764337416_0.jpg', ' NULL', ' NULL', '0', '0', '42', '1', '1', '2025-11-28 09:43:36', '2025-11-28 09:43:36'),
('159', 'productos/1764350555_0.jpg', NULL, NULL, '0', '0', '85', '1', '1', '2025-11-28 13:22:35', '2025-11-28 13:22:35'),
('160', 'productos/86mLjlFQqni6BmWrDcDObQtxkg8AFMQ7HMTzx96v.jpg', NULL, 'Cloro Kris', '0', '0', '283', '0', '1', '2025-11-28 15:45:20', '2025-11-28 15:45:20'),
('161', 'productos/1764359120_0.jpg', NULL, NULL, '0', '0', '283', '1', '1', '2025-11-28 15:45:20', '2025-11-28 15:45:20'),
('162', 'productos/1764359157_0.jpg', NULL, NULL, '0', '0', '73', '1', '1', '2025-11-28 15:45:57', '2025-11-28 15:45:57'),
('163', 'productos/Mw6AqYwPPfl6boHJ5Um3umOacbEYlwlJCvtYWTPG.jpg', NULL, 'Papel Higiénico El Rosal Plus', '0', '0', '284', '0', '1', '2025-11-28 15:48:40', '2025-11-28 15:48:40'),
('164', 'productos/1764359320_0.jpg', NULL, NULL, '0', '0', '284', '1', '1', '2025-11-28 15:48:40', '2025-11-28 15:48:40'),
('165', 'productos/fs4A6KQsPWLJLNWXYu9ZcPGSfgpLy8Cd6U3tKwNy.jpg', NULL, 'Jabón de baño Anita', '0', '0', '285', '0', '1', '2025-11-28 15:50:29', '2025-11-28 15:50:29'),
('166', 'productos/1764359429_0.jpg', NULL, NULL, '0', '0', '285', '1', '1', '2025-11-28 15:50:29', '2025-11-28 15:50:29'),
('167', 'productos/1IHJSA7LrSg8KEg5BPPo0ENpDQGd7AZ2libTf0Zn.jpg', NULL, 'DETERGENTE OSO BLANCO ', '0', '0', '286', '0', '1', '2025-11-28 15:53:05', '2025-11-28 15:53:05'),
('168', 'productos/1764359585_0.jpg', NULL, NULL, '0', '0', '286', '1', '1', '2025-11-28 15:53:05', '2025-11-28 15:53:05'),
('169', 'productos/Jl9QdHNZV7VQo1CPIbzqzM5pcagEgW2io9Cvg5RJ.jpg', NULL, 'LAVAPLATOS TAPA AMARILLA', '0', '0', '287', '0', '1', '2025-11-28 16:04:21', '2025-11-28 16:04:21'),
('170', 'productos/1764360261_0.jpg', NULL, NULL, '0', '0', '287', '1', '1', '2025-11-28 16:04:21', '2025-11-28 16:04:21'),
('171', 'productos/1764360642_0.jpg', NULL, NULL, '0', '0', '180', '1', '1', '2025-11-28 16:10:42', '2025-11-28 16:10:42'),
('172', 'productos/1764360998_0.webp', NULL, NULL, '0', '0', '182', '1', '1', '2025-11-28 16:16:38', '2025-11-28 16:16:38'),
('173', 'productos/1764361014_0.webp', NULL, NULL, '0', '0', '183', '1', '1', '2025-11-28 16:16:54', '2025-11-28 16:16:54'),
('174', 'productos/1764361142_0.jpg', NULL, NULL, '0', '0', '212', '1', '1', '2025-11-28 16:19:02', '2025-11-28 16:19:02'),
('175', 'productos/1764361252_0.jpg', NULL, NULL, '0', '0', '211', '1', '1', '2025-11-28 16:20:52', '2025-11-28 16:20:52'),
('176', 'productos/1764361449_0.jpg', NULL, NULL, '0', '0', '210', '1', '1', '2025-11-28 16:24:09', '2025-11-28 16:24:09'),
('177', 'productos/1764361737_0.jpg', NULL, NULL, '0', '0', '209', '1', '1', '2025-11-28 16:28:57', '2025-11-28 16:28:57'),
('178', 'productos/1764361976_0.jpg', NULL, NULL, '0', '0', '208', '1', '1', '2025-11-28 16:32:56', '2025-11-28 16:32:56'),
('179', 'productos/1764362176_0.jpg', NULL, NULL, '0', '0', '207', '1', '1', '2025-11-28 16:36:16', '2025-11-28 16:36:16'),
('180', 'productos/1764362289_0.jpg', NULL, NULL, '0', '0', '206', '1', '1', '2025-11-28 16:38:09', '2025-11-28 16:38:09'),
('181', 'productos/1764362374_0.jpg', NULL, NULL, '0', '0', '205', '1', '1', '2025-11-28 16:39:34', '2025-11-28 16:39:34'),
('182', 'productos/1764362463_0.jpg', NULL, NULL, '0', '0', '199', '1', '1', '2025-11-28 16:41:03', '2025-11-28 16:41:03'),
('183', 'productos/1764362659_0.jpg', NULL, NULL, '0', '0', '198', '1', '1', '2025-11-28 16:44:19', '2025-11-28 16:44:19'),
('184', 'productos/1764362750_0.jpg', NULL, NULL, '0', '0', '197', '1', '1', '2025-11-28 16:45:50', '2025-11-28 16:45:50'),
('185', 'productos/1764362799_0.jpg', NULL, NULL, '0', '0', '194', '1', '1', '2025-11-28 16:46:39', '2025-11-28 16:46:39'),
('186', 'productos/1764362850_0.jpg', NULL, NULL, '0', '0', '193', '1', '1', '2025-11-28 16:47:30', '2025-11-28 16:47:30'),
('189', 'productos/1764364235_0.jpg', NULL, NULL, '0', '0', '150', '1', '1', '2025-11-28 17:10:35', '2025-11-28 17:10:35'),
('190', 'productos/1764364281_0.jpg', NULL, NULL, '0', '0', '191', '1', '1', '2025-11-28 17:11:21', '2025-11-28 17:11:21'),
('191', 'productos/1764364346_0.jpg', NULL, NULL, '0', '0', '137', '1', '1', '2025-11-28 17:12:26', '2025-11-28 17:12:26'),
('192', 'productos/j1RaH6ywqYID1NYykbOGiE58WxxFyEFp3maVn1ud.jpg', NULL, 'Boka Bebidas Instantáneas De Frutas', '0', '0', '288', '0', '1', '2025-11-28 17:18:14', '2025-11-28 17:18:14'),
('193', 'productos/1764364694_0.jpg', NULL, NULL, '0', '0', '288', '1', '1', '2025-11-28 17:18:14', '2025-11-28 17:18:14');


-- Estructura de tabla `inventory_movements`
DROP TABLE IF EXISTS `inventory_movements`;
CREATE TABLE `inventory_movements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `type` enum('ingreso','salida','devolucion','ajuste','venta','compra') COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `quantity_before` int NOT NULL,
  `quantity_after` int NOT NULL,
  `unit_cost` decimal(10,2) DEFAULT NULL,
  `total_cost` decimal(10,2) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_movements_user_id_foreign` (`user_id`),
  KEY `inventory_movements_empresa_id_foreign` (`empresa_id`),
  KEY `inventory_movements_sucursal_id_foreign` (`sucursal_id`),
  KEY `inventory_movements_producto_id_created_at_index` (`producto_id`,`created_at`),
  KEY `inventory_movements_type_created_at_index` (`type`,`created_at`),
  CONSTRAINT `inventory_movements_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `inventory_movements_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventory_movements_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `inventory_movements_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `inventory_movements` (filtrado)
TRUNCATE TABLE `inventory_movements`;
INSERT INTO `inventory_movements` (`id`, `producto_id`, `type`, `quantity`, `quantity_before`, `quantity_after`, `unit_cost`, `total_cost`, `reference`, `notes`, `user_id`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
('1', '283', 'ingreso', '5000', '0', '5000', NULL, NULL, 'Creación producto: PROD-000283', 'Stock inicial del producto', '2', '1', '1', '2025-11-28 15:45:20', '2025-11-28 15:45:20'),
('2', '284', 'ingreso', '5000', '0', '5000', NULL, NULL, 'Creación producto: PROD-000284', 'Stock inicial del producto', '2', '1', '1', '2025-11-28 15:48:40', '2025-11-28 15:48:40'),
('3', '285', 'ingreso', '5000', '0', '5000', NULL, NULL, 'Creación producto: PROD-000285', 'Stock inicial del producto', '2', '1', '1', '2025-11-28 15:50:29', '2025-11-28 15:50:29'),
('4', '286', 'ingreso', '5000', '0', '5000', NULL, NULL, 'Creación producto: PROD-000286', 'Stock inicial del producto', '2', '1', '1', '2025-11-28 15:53:05', '2025-11-28 15:53:05'),
('5', '287', 'ingreso', '5000', '0', '5000', NULL, NULL, 'Creación producto: PROD-000287', 'Stock inicial del producto', '2', '1', '1', '2025-11-28 16:04:21', '2025-11-28 16:04:21');


-- Estructura de tabla `job_batches`
DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla job_batches: Sin datos en el rango de fechas


-- Estructura de tabla `jobs`
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla jobs: Sin datos en el rango de fechas


-- Estructura de tabla `marcas`
DROP TABLE IF EXISTS `marcas`;
CREATE TABLE `marcas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `marcas_slug_unique` (`slug`),
  KEY `marcas_empresa_id_foreign` (`empresa_id`),
  KEY `marcas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `marcas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `marcas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `marcas` (filtrado)
TRUNCATE TABLE `marcas`;
INSERT INTO `marcas` (`id`, `nombre`, `slug`, `descripcion`, `activo`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
('106', 'Ibiza', 'ibiza', 'Productos Ibiza', '1', '1', '1', '2025-11-28 10:16:50', '2025-11-28 10:16:51'),
('107', 'Consul', 'consul', 'Productos Consul', '1', '1', '1', '2025-11-28 10:38:00', '2025-11-28 10:38:03'),
('108', 'Kris', 'kris', 'Productos Kris', '1', '1', '1', '2025-11-28 10:38:00', '2025-11-28 10:38:03'),
('109', 'El Rosal', 'el-rosal', 'Productos El Rosal', '1', '1', '1', '2025-11-28 10:38:00', '2025-11-28 10:38:03');


-- Estructura de tabla `migrations`
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla migrations: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `migrations` (completo)
TRUNCATE TABLE `migrations`;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
('1', '0001_01_01_000000_create_users_table', '1'),
('2', '0001_01_01_000001_create_cache_table', '1'),
('3', '0001_01_01_000002_create_jobs_table', '1'),
('4', '2023_10_21_000000_add_two_factor_columns_to_users_table', '1'),
('5', '2024_01_01_000000_create_template_customizations_table', '1'),
('6', '2025_10_17_000000_add_verification_code_to_users_table', '1'),
('7', '2025_10_17_000001_create_active_sessions_table', '1'),
('8', '2025_10_17_000002_add_fields_to_active_sessions_table', '1'),
('9', '2025_10_17_205657_create_empresas_table', '1'),
('10', '2025_10_17_214709_create_sucursales_table', '1'),
('11', '2025_10_20_132700_add_empresa_id_to_users_table', '1'),
('12', '2025_10_20_171800_add_profile_fields_to_users_table', '1'),
('13', '2025_10_20_200325_create_permission_tables', '1'),
('14', '2025_10_22_201649_add_telefono_and_email_to_empresas_table', '1'),
('15', '2025_10_24_162929_add_module_to_permissions_table', '1'),
('16', '2025_10_27_020859_create_notifications_table', '1'),
('17', '2025_10_27_022318_create_activity_log_table', '1'),
('18', '2025_10_27_022319_add_event_column_to_activity_log_table', '1'),
('19', '2025_10_27_022320_add_batch_uuid_column_to_activity_log_table', '1'),
('20', '2025_10_29_123000_create_comprobantes_table', '1'),
('21', '2025_11_01_000000_create_series_table', '1'),
('22', '2025_11_03_000001_create_cajas_table', '1'),
('23', '2025_11_03_160220_create_exchange_rates_table', '1'),
('24', '2025_11_03_161309_fix_exchange_rates_source_column', '1'),
('25', '2025_11_03_162823_add_numero_corte_to_cajas_table', '1'),
('26', '2025_11_05_090016_create_reunions_table', '1'),
('27', '2025_11_05_100000_remove_unique_constraint_from_cajas_table', '1'),
('28', '2025_11_06_090055_create_pais_table', '1'),
('29', '2025_11_06_090208_add_pais_id_to_empresas_table', '1'),
('30', '2025_11_10_120000_create_clientes_table', '1'),
('31', '2025_11_10_150121_create_marcas_table', '1'),
('32', '2025_11_10_150141_create_categorias_table', '1'),
('33', '2025_11_10_154642_create_productos_table', '1'),
('34', '2025_11_10_155453_create_images_table', '1'),
('35', '2025_11_10_155454_add_fields_to_images_table', '1'),
('36', '2025_11_10_160000_create_producto_variants_table', '1'),
('37', '2025_11_10_160001_add_image_fields_to_producto_variants_table', '1'),
('38', '2025_11_10_160002_add_sku_price_adjustment_quantity_to_producto_variants_table', '1'),
('39', '2025_11_10_160003_add_additional_fields_to_productos_table', '1'),
('40', '2025_11_10_160004_create_producto_inventory_settings_table', '1'),
('41', '2025_11_10_160005_create_producto_seo_table', '1'),
('42', '2025_11_13_000001_create_reviews_table', '1'),
('43', '2025_11_13_122414_create_wishlists_table', '1'),
('44', '2025_11_13_143714_create_search_index_for_products_table', '1'),
('45', '2025_11_14_083315_create_pedidos_table', '1'),
('46', '2025_11_14_083326_create_detalle_pedidos_table', '1'),
('47', '2025_11_14_121623_create_movimiento_pedido_table', '1'),
('48', '2025_11_14_152802_add_username_and_telephone_to_users_table', '1'),
('49', '2025_11_14_160052_add_note_to_pedidos_table', '1'),
('50', '2025_11_14_200523_create_pedido_pago_table', '1'),
('51', '2025_11_14_200524_add_total_bs_to_pedido_pago_table', '1'),
('52', '2025_11_15_000001_create_bancos_table', '1'),
('53', '2025_11_15_000002_create_referencias_bancarias_table', '1'),
('54', '2025_11_15_122143_add_tipo_atencion_to_historico_pedidos', '1'),
('55', '2025_11_15_125248_add_nota_to_pedido_pago', '1'),
('56', '2025_11_16_204410_add_location_fields_to_active_sessions_table', '1'),
('57', '2025_11_16_204411_create_empleados_table', '1'),
('58', '2025_11_17_000000_create_empleado_pedido_table', '1'),
('59', '2025_11_17_005213_add_caja_id_to_pedido_pago_table', '1'),
('60', '2025_11_24_085341_create_personal_access_tokens_table', '1'),
('61', '2025_11_24_090034_add_api_token_to_users_table', '1'),
('62', '2025_11_24_103514_add_unique_constraint_to_wishlists_table', '1'),
('63', '2025_11_24_125702_add_fecha_entrega_to_pedidos_table', '1'),
('64', '2025_11_24_130441_create_resenas_table', '1'),
('65', '2025_12_19_000000_add_simbolo_moneda_to_pais_table', '1'),
('66', '2025_11_26_123000_create_pedido_historial_table', '2'),
('67', '2025_01_27_000000_add_profile_fields_to_users_table', '3'),
('68', '2025_11_26_220850_create_product_reviews_table', '3'),
('69', '2025_11_27_101754_ensure_empleado_pedido_table_exists', '3'),
('70', '2025_11_26_000000_add_precio_bs_to_producto_variants_table', '4'),
('71', '2025_11_26_000000_add_sucursal_id_to_products_table', '5'),
('72', '2024_01_01_000001_create_inventory_movements_table', '6'),
('73', '2025_01_15_000000_add_batch_fields_to_productos_table', '7'),
('74', '2025_11_28_000000_add_variant_fields_to_detalle_pedidos_table', '8');


-- Estructura de tabla `model_has_permissions`
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla model_has_permissions: Sin columnas de fecha, respaldando todos los datos
-- Tabla model_has_permissions: Sin datos


-- Estructura de tabla `model_has_roles`
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla model_has_roles: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `model_has_roles` (completo)
TRUNCATE TABLE `model_has_roles`;
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
('1', 'App\\Models\\User', '1'),
('2', 'App\\Models\\User', '2'),
('4', 'App\\Models\\User', '3'),
('5', 'App\\Models\\User', '4'),
('5', 'App\\Models\\User', '5'),
('5', 'App\\Models\\User', '6'),
('5', 'App\\Models\\User', '7'),
('5', 'App\\Models\\User', '8'),
('5', 'App\\Models\\User', '9');


-- Estructura de tabla `notifications`
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_user_id_read_at_index` (`user_id`,`read_at`),
  CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla notifications: Sin datos en el rango de fechas


-- Estructura de tabla `pais`
DROP TABLE IF EXISTS `pais`;
CREATE TABLE `pais` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso2` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso3` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_telefonico` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moneda_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `simbolo_moneda` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idioma_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continente` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zona_horaria` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `formato_fecha` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dd/mm/yyyy',
  `formato_moneda` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.234,56',
  `impuesto_predeterminado` decimal(5,2) NOT NULL DEFAULT '0.00',
  `separador_miles` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `separador_decimales` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `decimales_moneda` int NOT NULL DEFAULT '2',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pais_codigo_iso2_unique` (`codigo_iso2`),
  UNIQUE KEY `pais_codigo_iso3_unique` (`codigo_iso3`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pais: Sin datos en el rango de fechas


-- Estructura de tabla `password_reset_tokens`
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla password_reset_tokens: Sin datos en el rango de fechas


-- Estructura de tabla `pedido_historial`
DROP TABLE IF EXISTS `pedido_historial`;
CREATE TABLE `pedido_historial` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `usuario_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_historial_pedido_id_foreign` (`pedido_id`),
  KEY `pedido_historial_usuario_id_foreign` (`usuario_id`),
  CONSTRAINT `pedido_historial_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_historial_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedido_historial: Sin datos en el rango de fechas


-- Estructura de tabla `pedido_pago`
DROP TABLE IF EXISTS `pedido_pago`;
CREATE TABLE `pedido_pago` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `caja_id` bigint unsigned DEFAULT NULL,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` decimal(15,2) DEFAULT NULL,
  `referencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metodo_pago` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `nota` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDENTE',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_pago_empresaid_foreign` (`empresaId`),
  KEY `pedido_pago_userid_foreign` (`userId`),
  KEY `pedido_pago_pedidoid_foreign` (`pedidoId`),
  KEY `pedido_pago_caja_id_foreign` (`caja_id`),
  CONSTRAINT `pedido_pago_caja_id_foreign` FOREIGN KEY (`caja_id`) REFERENCES `cajas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pedido_pago_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `pedido_pago` (filtrado)
TRUNCATE TABLE `pedido_pago`;
INSERT INTO `pedido_pago` (`id`, `caja_id`, `fecha`, `total_usd`, `total_bs`, `referencia`, `metodo_pago`, `empresaId`, `userId`, `pedidoId`, `nota`, `status`, `created_at`, `updated_at`) VALUES
('7', NULL, '2025-11-26', '31', '31.00', NULL, 'Efectivo', '1', '2', '7', '', 'PENDENTE', '2025-11-28 16:51:43', '2025-11-28 16:51:43'),
('8', NULL, '2025-11-26', '0.50', '0.50', '123123', 'Pago Móvil', '1', '2', '7', '', 'PENDENTE', '2025-11-28 16:51:43', '2025-11-28 16:51:43'),
('9', NULL, '2025-11-26', '7', '7.00', NULL, 'Efectivo', '1', '2', '8', '', 'PENDENTE', '2025-11-28 16:56:55', '2025-11-28 16:56:55'),
('10', NULL, '2025-11-26', '0.50', '0.50', '3456', 'Pago Móvil', '1', '2', '8', '', 'PENDENTE', '2025-11-28 16:56:55', '2025-11-28 16:56:55'),
('11', NULL, '2025-11-26', '3', '3.00', NULL, 'Efectivo', '1', '2', '9', '', 'PENDENTE', '2025-11-28 17:02:48', '2025-11-28 17:02:48'),
('12', NULL, '2025-11-26', '0.75', '0.75', '1233', 'Pago Móvil', '1', '2', '9', '', 'PENDENTE', '2025-11-28 17:02:48', '2025-11-28 17:02:48');


-- Estructura de tabla `pedidos`
DROP TABLE IF EXISTS `pedidos`;
CREATE TABLE `pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `fecha_entrega` timestamp NULL DEFAULT NULL,
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo_pago` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ubicacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitud` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitud` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nota` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedidos_empresaid_foreign` (`empresaId`),
  KEY `pedidos_userid_foreign` (`userId`),
  CONSTRAINT `pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `pedidos` (filtrado)
TRUNCATE TABLE `pedidos`;
INSERT INTO `pedidos` (`id`, `fecha`, `fecha_entrega`, `total_usd`, `total_bs`, `codigo`, `metodo_pago`, `ubicacion`, `longitud`, `latitud`, `nota`, `estado`, `empresaId`, `userId`, `created_at`, `updated_at`) VALUES
('7', '2025-11-28 16:51:43', NULL, '31.5', '31.5', '0008', 'Mixto', 'Bajo el Reloj, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.8813312', '10.4962577', NULL, 'Pendiente', '1', '2', '2025-11-28 16:51:43', '2025-11-28 16:51:43'),
('8', '2025-11-28 16:56:55', NULL, '7.5', '7.5', '0009', 'Mixto', 'Seguros La Previsora, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.8813507', '10.4962903', NULL, 'Pendiente', '1', '2', '2025-11-28 16:56:55', '2025-11-28 16:56:55'),
('9', '2025-11-28 17:02:48', NULL, '3.75', '3.75', '0010', 'Mixto', 'Bajo el Reloj, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.8813277', '10.4962529', NULL, 'Pendiente', '1', '2', '2025-11-28 17:02:48', '2025-11-28 17:02:48');


-- Estructura de tabla `permissions`
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`),
  KEY `permissions_module_index` (`module`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla permissions: Sin datos en el rango de fechas


-- Estructura de tabla `personal_access_tokens`
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_expires_at_index` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla personal_access_tokens: Sin datos en el rango de fechas


-- Estructura de tabla `product_reviews`
DROP TABLE IF EXISTS `product_reviews`;
CREATE TABLE `product_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` tinyint unsigned NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `verified_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_reviews_producto_id_user_id_unique` (`producto_id`,`user_id`),
  KEY `product_reviews_user_id_foreign` (`user_id`),
  KEY `product_reviews_producto_id_is_approved_index` (`producto_id`,`is_approved`),
  CONSTRAINT `product_reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla product_reviews: Sin datos en el rango de fechas


-- Estructura de tabla `producto_inventory_settings`
DROP TABLE IF EXISTS `producto_inventory_settings`;
CREATE TABLE `producto_inventory_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `low_stock_threshold` int NOT NULL DEFAULT '5',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_inventory_settings_producto_id_index` (`producto_id`),
  KEY `producto_inventory_settings_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_inventory_settings_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_inventory_settings_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_inventory_settings` (filtrado)
TRUNCATE TABLE `producto_inventory_settings`;
INSERT INTO `producto_inventory_settings` (`id`, `producto_id`, `track_inventory`, `allow_backorder`, `inventory_policy`, `low_stock_threshold`, `empresa_id`, `created_at`, `updated_at`) VALUES
('4', '283', '1', '0', 'deny', '5', '1', '2025-11-28 15:45:20', '2025-11-28 15:45:20'),
('5', '284', '1', '0', 'deny', '5', '1', '2025-11-28 15:48:40', '2025-11-28 15:48:40'),
('6', '285', '1', '0', 'deny', '5', '1', '2025-11-28 15:50:29', '2025-11-28 15:50:29'),
('7', '286', '1', '0', 'deny', '5', '1', '2025-11-28 15:53:05', '2025-11-28 15:57:33'),
('8', '287', '1', '0', 'deny', '5', '1', '2025-11-28 16:04:21', '2025-11-28 16:05:23'),
('9', '288', '1', '0', 'deny', '5', '1', '2025-11-28 17:18:14', '2025-11-28 17:21:24');


-- Estructura de tabla `producto_seo`
DROP TABLE IF EXISTS `producto_seo`;
CREATE TABLE `producto_seo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_seo_producto_id_index` (`producto_id`),
  KEY `producto_seo_empresa_id_index` (`empresa_id`),
  KEY `producto_seo_sku_index` (`sku`),
  KEY `producto_seo_barcode_index` (`barcode`),
  CONSTRAINT `producto_seo_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_seo_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_seo` (filtrado)
TRUNCATE TABLE `producto_seo`;
INSERT INTO `producto_seo` (`id`, `producto_id`, `sku`, `barcode`, `meta_title`, `meta_description`, `tags`, `featured`, `empresa_id`, `created_at`, `updated_at`) VALUES
('76', '283', 'CLORO-KRIS-SWWW', NULL, NULL, NULL, NULL, '0', '1', '2025-11-28 15:45:20', '2025-11-28 15:45:20'),
('77', '73', 'CLORO-LIMPIEZA-EXTREMA-1L-D7ZR', '', '', '', '', '0', '1', '2025-11-28 15:45:57', '2025-11-28 15:45:57'),
('78', '284', 'PAPEL-HIGIENICO-EL-ROSAL-PLUS-PYST', NULL, NULL, NULL, NULL, '0', '1', '2025-11-28 15:48:40', '2025-11-28 15:48:40'),
('79', '285', NULL, NULL, NULL, NULL, NULL, '0', '1', '2025-11-28 15:50:29', '2025-11-28 15:50:29'),
('80', '286', 'DETERGENTE-OSO-BLANCO-8GVQ', '', '', '', '', '0', '1', '2025-11-28 15:53:05', '2025-11-28 15:56:44'),
('81', '287', 'LAVAPLATOS-TAPA-AMARILLA-ZTCN', '', '', '', '', '0', '1', '2025-11-28 16:04:21', '2025-11-28 16:05:23'),
('82', '180', 'JUGO-VALENCIA-COCTEL-FGCN', '', '', '', '', '0', '1', '2025-11-28 16:10:42', '2025-11-28 16:10:42'),
('83', '182', 'JUGO-VALENCIA-DURAZNO-YPIK', '', '', '', '', '0', '1', '2025-11-28 16:16:38', '2025-11-28 16:16:38'),
('84', '183', 'JUGO-VALENCIA-PERA-NNAQ', '', '', '', '', '0', '1', '2025-11-28 16:16:54', '2025-11-28 16:16:54'),
('85', '212', 'REFRESCO-HIT-UVA-DSTD', '', '', '', '', '0', '1', '2025-11-28 16:19:02', '2025-11-28 16:19:02'),
('86', '211', 'REFRESCO-HIT-NARANJA-XYHH', '', '', '', '', '0', '1', '2025-11-28 16:20:52', '2025-11-28 16:20:52'),
('87', '210', 'REFRESCO-CHINOTTO-GH24', '', '', '', '', '0', '1', '2025-11-28 16:24:09', '2025-11-28 16:24:09'),
('88', '209', 'REFRESCO-FRESCOLITA-QUUO', '', '', '', '', '0', '1', '2025-11-28 16:28:57', '2025-11-28 16:28:57'),
('89', '208', 'REFRESCO-GOLDEN-7UP-GTHQ', '', '', '', '', '0', '1', '2025-11-28 16:32:56', '2025-11-28 16:32:56'),
('90', '207', 'REFRESCO-GOLDEN-MANZANA-JUUX', '', '', '', '', '0', '1', '2025-11-28 16:36:17', '2025-11-28 16:36:17'),
('91', '206', 'REFRESCO-GOLDEN-PINA-MAQ4', '', '', '', '', '0', '1', '2025-11-28 16:38:09', '2025-11-28 16:38:09'),
('92', '205', 'REFRESCO-GOLDEN-COLITA-P9TI', '', '', '', '', '0', '1', '2025-11-28 16:39:34', '2025-11-28 16:39:34'),
('93', '199', 'GLUP-FRESH-AI0Q', '', '', '', '', '0', '1', '2025-11-28 16:41:03', '2025-11-28 16:41:03'),
('94', '198', '', '', '', '', '', '0', '1', '2025-11-28 16:44:19', '2025-11-28 16:44:19'),
('95', '197', '', '', '', '', '', '0', '1', '2025-11-28 16:45:50', '2025-11-28 16:45:50'),
('96', '194', 'GLUP-MANZANA-FP0X', '', '', '', '', '0', '1', '2025-11-28 16:46:39', '2025-11-28 16:46:39'),
('97', '193', 'GLUP-UVA-TNXA', '', '', '', '', '0', '1', '2025-11-28 16:47:30', '2025-11-28 16:47:30'),
('98', '150', 'REFRESCO-FRUT-COLA-2L-M9HZ', '', '', '', '', '0', '1', '2025-11-28 17:08:48', '2025-11-28 17:08:48'),
('99', '191', '', '', '', '', '', '0', '1', '2025-11-28 17:11:21', '2025-11-28 17:11:21'),
('100', '137', '', '', '', '', '', '0', '1', '2025-11-28 17:12:26', '2025-11-28 17:12:26'),
('101', '288', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '', '', '', '', '0', '1', '2025-11-28 17:18:14', '2025-11-28 17:19:40');


-- Estructura de tabla `producto_variants`
DROP TABLE IF EXISTS `producto_variants`;
CREATE TABLE `producto_variants` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `values` json NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_adjustment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `image_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_thumbnail_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_variants_producto_id_index` (`producto_id`),
  KEY `producto_variants_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_variants_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_variants_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=437 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_variants` (filtrado)
TRUNCATE TABLE `producto_variants`;
INSERT INTO `producto_variants` (`id`, `producto_id`, `name`, `values`, `sku`, `price_adjustment`, `precio_bs`, `quantity`, `image_path`, `image_thumbnail_path`, `alt_text`, `empresa_id`, `created_at`, `updated_at`) VALUES
('72', '42', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CHIMO-EL-APURENO-IZGI', '0.00', '0.00', '1000', NULL, NULL, 'Cantidad: 1 und - Chimo el apureño', '1', '2025-11-21 01:13:56', '2025-11-28 09:56:26'),
('73', '43', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CHIMO-EL-TIGRITO-AMARILLO-DZIS', '0.00', '0.00', '200', NULL, NULL, 'Cantidad: 1 und - Chimo El Tigrito Amarillo', '1', '2025-11-21 01:13:56', '2025-11-28 09:49:27'),
('113', '73', 'Volumen: 1L', '{\"Volumen: 1L\": \"1L\"}', 'CLORO-LIMPIEZA-EXTREMA-1L-D7ZR', '0.00', '0.00', '75', NULL, NULL, 'Volumen: 1L - Cloro Limpieza Extrema 1L', '1', '2025-11-21 01:13:57', '2025-11-28 15:45:57'),
('200', '137', 'volumen', '{\"Volumen\": \"1L\"}', '', '0.75', '0.00', '80', NULL, NULL, 'Volumen: 1L - Refresco Pepsi Cola', '1', '2025-11-21 01:13:57', '2025-11-28 17:12:26'),
('201', '137', 'volumen', '{\"Volumen\": \"1.5L\"}', '', '1.15', '0.00', '60', NULL, NULL, 'Volumen: 1.5L - Refresco Pepsi Cola', '1', '2025-11-21 01:13:57', '2025-11-28 17:12:26'),
('202', '137', 'volumen', '{\"Volumen\": \"2L\"}', '', '1.55', '0.00', '50', NULL, NULL, 'Volumen: 2L - Refresco Pepsi Cola', '1', '2025-11-21 01:13:57', '2025-11-28 17:12:26'),
('215', '150', 'Volumen: 2L', '{\"Volumen: 2L\": \"2L\"}', 'REFRESCO-FRUT-COLA-2L-M9HZ', '0.00', '0.00', '50', NULL, NULL, 'Volumen: 2L - Refresco Frut Cola 2L', '1', '2025-11-21 01:13:57', '2025-11-28 17:10:35'),
('245', '180', 'Volumen: 1L', '{\"Volumen: 1L\": \"1L\"}', 'JUGO-VALENCIA-COCTEL-FGCN', '0.00', '0.00', '50', NULL, NULL, 'Volumen: 1L - Jugo Valencia Coctel', '1', '2025-11-21 01:13:57', '2025-11-28 16:10:42'),
('247', '182', 'Volumen: 1L', '{\"Volumen: 1L\": \"1L\"}', 'JUGO-VALENCIA-DURAZNO-YPIK', '0.00', '0.00', '50', NULL, NULL, 'Volumen: 1L - Jugo Valencia Durazno', '1', '2025-11-21 01:13:57', '2025-11-28 16:16:38'),
('248', '183', 'Volumen: 1L', '{\"Volumen: 1L\": \"1L\"}', 'JUGO-VALENCIA-PERA-NNAQ', '0.00', '0.00', '50', NULL, NULL, 'Volumen: 1L - Jugo Valencia Pera', '1', '2025-11-21 01:13:57', '2025-11-28 16:16:54'),
('271', '194', 'volumen', '{\"Volumen\": \"2L\"}', 'GLUP-MANZANA-FP0X', '1.65', '0.00', '45', NULL, NULL, 'Volumen: 2L - Glup Manzana', '1', '2025-11-21 01:13:57', '2025-11-28 16:46:39'),
('281', '197', 'volumen', '{\"Volumen\": \"1L\"}', '', '0.85', '0.00', '65', NULL, NULL, 'Volumen: 1L - Glup Cola Negra', '1', '2025-11-21 01:13:57', '2025-11-28 16:45:50'),
('283', '197', 'volumen', '{\"Volumen\": \"2L\"}', '', '1.65', '0.00', '35', NULL, NULL, 'Volumen: 2L - Glup Cola Negra', '1', '2025-11-21 01:13:57', '2025-11-28 16:45:50'),
('291', '199', 'volumen', '{\"Volumen\": \"2L\"}', 'GLUP-FRESH-AI0Q', '1.65', '0.00', '35', NULL, NULL, 'Volumen: 2L - Glup Fresh', '1', '2025-11-21 01:13:57', '2025-11-28 16:41:44'),
('312', '205', 'Volumen: 1L', '{\"Volumen: 1L\": \"1L\"}', 'REFRESCO-GOLDEN-COLITA-P9TI', '0.75', '0.00', '80', NULL, NULL, 'Volumen: 1L - Refresco Golden Colita', '1', '2025-11-21 01:13:57', '2025-11-28 16:39:34'),
('313', '205', 'volumen', '{\"Volumen\": \"1.5L\"}', 'REFRESCO-GOLDEN-COLITA-P9TI', '1.15', '0.00', '60', NULL, NULL, 'Volumen: 1.5L - Refresco Golden Colita', '1', '2025-11-21 01:13:57', '2025-11-28 16:39:34'),
('314', '205', 'volumen', '{\"Volumen\": \"2L\"}', 'REFRESCO-GOLDEN-COLITA-P9TI', '1.55', '0.00', '50', NULL, NULL, 'Volumen: 2L - Refresco Golden Colita', '1', '2025-11-21 01:13:57', '2025-11-28 16:39:34'),
('318', '206', 'volumen', '{\"Volumen\": \"1L\"}', 'REFRESCO-GOLDEN-PINA-MAQ4', '1.15', '0.00', '60', NULL, NULL, 'Volumen: 1L - Refresco Golden Piña', '1', '2025-11-21 01:13:57', '2025-11-28 16:38:09'),
('319', '206', 'volumen', '{\"Volumen\": \"1.5L\"}', 'REFRESCO-GOLDEN-PINA-MAQ4', '1.55', '0.00', '50', NULL, NULL, 'Volumen: 1.5L - Refresco Golden Piña', '1', '2025-11-21 01:13:57', '2025-11-28 16:38:09'),
('320', '207', 'volumen', '{\"Volumen\": \"1L\"}', 'REFRESCO-GOLDEN-MANZANA-JUUX', '0.00', '0.00', '120', NULL, NULL, 'Volumen: 1Lt- Refresco Golden Manzana', '1', '2025-11-21 01:13:57', '2025-11-28 16:36:17'),
('321', '207', 'volumen', '{\"Volumen\": \"1.5Lt\"}', 'REFRESCO-GOLDEN-MANZANA-JUUX', '0.35', '0.00', '100', NULL, NULL, 'Volumen: 1.5Lt - Refresco Golden Manzana', '1', '2025-11-21 01:13:57', '2025-11-28 16:36:17'),
('322', '207', 'volumen', '{\"Volumen\": \"2L\"}', 'REFRESCO-GOLDEN-MANZANA-JUUX', '0.75', '0.00', '80', NULL, NULL, 'Volumen: 2Lt - Refresco Golden Manzana', '1', '2025-11-21 01:13:57', '2025-11-28 16:36:17'),
('342', '211', 'Volumen: 1L', '{\"Volumen: 1L\": \"1L\"}', 'REFRESCO-HIT-NARANJA-XYHH', '0.75', '0.00', '80', NULL, NULL, 'Volumen: 1L - Refresco Hit Naranja', '1', '2025-11-21 01:13:57', '2025-11-28 16:21:32'),
('347', '212', 'volumen', '{\"Volumen\": \"1L\"}', 'REFRESCO-HIT-UVA-DSTD', '0.75', '0.00', '80', NULL, NULL, 'Volumen: 1L - Refresco Hit Uva', '1', '2025-11-21 01:13:57', '2025-11-28 16:20:01'),
('414', '66', 'peso', '{\"Peso\": \"28g\"}', 'TOSTONES-CON-AJO-TOM-ZVZI', '7.00', '8.00', '0', 'productos/1764344177_variant_1.jpg', 'productos/thumb_1764344177_variant_1.jpg', '', '1', '2025-11-27 23:11:14', '2025-11-28 11:38:08'),
('415', '286', 'peso', '{\"Peso\": \"400g\"}', 'DETERGENTE-OSO-BLANCO-8GVQ', '0.00', '0.00', '0', 'productos/1764359804_variant_0.jpg', 'productos/thumb_1764359804_variant_0.jpg', '', '1', '2025-11-28 15:56:44', '2025-11-28 15:57:33'),
('416', '286', 'peso', '\"{\\\"Peso\\\":\\\"800g\\\"}\"', 'DETERGENTE-OSO-BLANCO-8GVQ', '0.00', '0.00', '0', 'productos/1764359853_variant_1.jpg', 'productos/thumb_1764359853_variant_1.jpg', '', '1', '2025-11-28 15:57:33', '2025-11-28 15:57:33'),
('417', '287', 'volumen', '{\"Volumen\": \"450ml\"}', 'LAVAPLATOS-TAPA-AMARILLA-ZTCN', '0.00', '0.00', '0', NULL, NULL, '', '1', '2025-11-28 16:04:21', '2025-11-28 16:05:23'),
('418', '287', 'volumen', '\"{\\\"Volumen\\\":\\\"900ml\\\"}\"', 'LAVAPLATOS-TAPA-AMARILLA-ZTCN', '0.00', '0.00', '0', 'productos/1764360323_variant_1.jpg', 'productos/thumb_1764360323_variant_1.jpg', '', '1', '2025-11-28 16:05:23', '2025-11-28 16:05:23'),
('419', '212', 'volumen', '\"{\\\"Volumen\\\":\\\"2L\\\"}\"', 'REFRESCO-HIT-UVA-DSTD', '0.00', '0.00', '0', 'productos/1764361201_variant_1.jpg', 'productos/thumb_1764361201_variant_1.jpg', '', '1', '2025-11-28 16:20:01', '2025-11-28 16:20:01'),
('420', '211', 'volumen', '\"{\\\"Volumen\\\":\\\"2L\\\"}\"', 'REFRESCO-HIT-NARANJA-XYHH', '0.00', '0.00', '0', 'productos/1764361292_variant_1.jpg', 'productos/thumb_1764361292_variant_1.jpg', '', '1', '2025-11-28 16:21:32', '2025-11-28 16:21:32'),
('421', '210', 'volumen', '\"{\\\"Volumen\\\":\\\"400ml\\\"}\"', 'REFRESCO-CHINOTTO-GH24', '0.00', '0.00', '0', 'productos/1764361598_variant_0.jpg', 'productos/thumb_1764361598_variant_0.jpg', '', '1', '2025-11-28 16:26:38', '2025-11-28 16:26:38'),
('422', '210', 'volumen', '\"{\\\"Volumen\\\":\\\"1L\\\"}\"', 'REFRESCO-CHINOTTO-GH24', '0.00', '0.00', '0', 'productos/1764361598_variant_1.jpg', 'productos/thumb_1764361598_variant_1.jpg', '', '1', '2025-11-28 16:26:38', '2025-11-28 16:26:38'),
('423', '210', 'volumen', '\"{\\\"Volumen\\\":\\\"2L\\\"}\"', 'REFRESCO-CHINOTTO-GH24', '0.00', '0.00', '0', 'productos/1764361598_variant_2.jpg', 'productos/thumb_1764361598_variant_2.jpg', '', '1', '2025-11-28 16:26:38', '2025-11-28 16:26:38'),
('424', '209', 'volumen', '\"{\\\"Volumen\\\":\\\"1L\\\"}\"', 'REFRESCO-FRESCOLITA-QUUO', '0.00', '0.00', '0', NULL, NULL, '', '1', '2025-11-28 16:31:41', '2025-11-28 16:31:41'),
('425', '209', 'volumen', '\"{\\\"Volumen\\\":\\\"2L\\\"}\"', 'REFRESCO-FRESCOLITA-QUUO', '0.00', '0.00', '0', 'productos/1764361901_variant_1.jpg', 'productos/thumb_1764361901_variant_1.jpg', '', '1', '2025-11-28 16:31:41', '2025-11-28 16:31:41'),
('426', '209', 'volumen', '\"{\\\"Volumen\\\":\\\"400ml\\\"}\"', 'REFRESCO-FRESCOLITA-QUUO', '0.00', '0.00', '0', 'productos/1764361901_variant_2.jpg', 'productos/thumb_1764361901_variant_2.jpg', '', '1', '2025-11-28 16:31:41', '2025-11-28 16:31:41'),
('428', '199', 'volumen', '{\"Volumen\": \"400ml\"}', 'GLUP-FRESH-AI0Q', '0.00', '0.00', '0', 'productos/1764362504_variant_1.jpg', 'productos/thumb_1764362504_variant_1.jpg', '', '1', '2025-11-28 16:41:03', '2025-11-28 16:41:44'),
('429', '288', 'sabor', '{\"Sabor\": \"Guanabana\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', NULL, NULL, '', '1', '2025-11-28 17:18:14', '2025-11-28 17:21:24'),
('430', '288', 'sabor', '{\"Sabor\": \"Durazno\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364884_variant_1.jpg', 'productos/thumb_1764364884_variant_1.jpg', '', '1', '2025-11-28 17:18:14', '2025-11-28 17:21:24'),
('431', '288', 'sabor', '{\"Sabor\": \"Limón\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364884_variant_2.jpg', 'productos/thumb_1764364884_variant_2.jpg', '', '1', '2025-11-28 17:18:14', '2025-11-28 17:21:24'),
('432', '288', 'sabor', '{\"Sabor\": \"Maracuyá\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364884_variant_3.jpg', 'productos/thumb_1764364884_variant_3.jpg', '', '1', '2025-11-28 17:18:14', '2025-11-28 17:21:24'),
('433', '288', 'sabor', '{\"Sabor\": \"Naranja\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364884_variant_4.jpg', 'productos/thumb_1764364884_variant_4.jpg', '', '1', '2025-11-28 17:18:14', '2025-11-28 17:21:25'),
('434', '288', 'sabor', '{\"Sabor\": \"Panela de limon\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364885_variant_5.jpg', 'productos/thumb_1764364885_variant_5.jpg', '', '1', '2025-11-28 17:19:41', '2025-11-28 17:21:25'),
('435', '288', 'sabor', '{\"Sabor\": \"Salpicon de frutas\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364885_variant_6.jpg', 'productos/thumb_1764364885_variant_6.jpg', '', '1', '2025-11-28 17:19:41', '2025-11-28 17:21:25'),
('436', '288', 'sabor', '{\"Sabor\": \"Tamarindo\"}', 'BOKA-BEBIDAS-INSTANTANEAS-DE-FRUTAS-1BP1', '0.00', '0.00', '0', 'productos/1764364885_variant_7.jpg', 'productos/thumb_1764364885_variant_7.jpg', '', '1', '2025-11-28 17:19:41', '2025-11-28 17:21:25');


-- Estructura de tabla `productos`
DROP TABLE IF EXISTS `productos`;
CREATE TABLE `productos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `batch_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `requires_batch_tracking` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `has_variants` tinyint(1) NOT NULL DEFAULT '0',
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `quantity` int NOT NULL DEFAULT '0',
  `quantity_alert` int NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `categoria_id` bigint unsigned NOT NULL,
  `marca_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `productos_code_unique` (`code`),
  KEY `productos_empresa_id_index` (`empresa_id`),
  KEY `productos_categoria_id_index` (`categoria_id`),
  KEY `productos_marca_id_index` (`marca_id`),
  KEY `productos_name_index` (`name`),
  KEY `productos_price_index` (`price`),
  KEY `productos_quantity_index` (`quantity`),
  KEY `productos_status_quantity_index` (`status`,`quantity`),
  KEY `productos_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `productos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_marca_id_foreign` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=289 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `productos` (filtrado)
TRUNCATE TABLE `productos`;
INSERT INTO `productos` (`id`, `code`, `sku`, `barcode`, `batch_number`, `expiry_date`, `requires_batch_tracking`, `name`, `price`, `precio_bs`, `description`, `tags`, `meta_title`, `meta_description`, `has_variants`, `track_inventory`, `featured`, `allow_backorder`, `inventory_policy`, `quantity`, `quantity_alert`, `status`, `empresa_id`, `sucursal_id`, `categoria_id`, `marca_id`, `created_at`, `updated_at`) VALUES
('73', 'CLO-91036', NULL, NULL, NULL, NULL, '0', 'Cloro Limpieza Extrema 1L', '2.15', '75.25', 'Cloro de limpieza extrema 1 Lt', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '75', '10', '1', '1', '1', '4', '45', '2025-11-21 01:13:57', '2025-11-28 15:45:57'),
('135', 'PEP-66089', NULL, NULL, NULL, NULL, '0', 'Pepsi Original 350ml', '1.20', '42.00', 'Bebida gaseosa sabor cola', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '1', '6', '35', '2025-11-21 01:13:57', '2025-11-28 17:13:15'),
('136', 'PEP-35958', NULL, NULL, NULL, NULL, '0', 'Pepsi Original 500ml', '1.70', '59.50', 'Bebida gaseosa sabor cola', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '80', '10', '0', '1', '1', '6', '35', '2025-11-21 01:13:57', '2025-11-28 17:13:14'),
('181', 'JUG-46481', NULL, NULL, NULL, NULL, '0', 'Jugo Valencia Naranjada', '2.15', '75.25', 'Jugo de naranja', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '55', '10', '0', '1', '1', '6', '94', '2025-11-21 01:13:57', '2025-11-28 16:17:11'),
('192', 'GLU-33705', NULL, NULL, NULL, NULL, '0', 'Glup Limón', '0.95', '33.25', 'Refresco sabor limón', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '310', '10', '0', '1', '1', '6', '92', '2025-11-21 01:13:57', '2025-11-28 17:10:49'),
('283', 'PROD-000283', NULL, NULL, NULL, NULL, '0', 'Cloro Kris', '0.00', '0.00', 'Cloro Kris 1 Lt', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '0', '1', '1', '1', '5', '108', '2025-11-28 15:45:20', '2025-11-28 15:45:20'),
('284', 'PROD-000284', NULL, NULL, NULL, NULL, '0', 'Papel Higiénico El Rosal Plus', '0.00', '0.00', 'Papel Higiénico de 4 rollos', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '0', '1', '1', '1', '5', '109', '2025-11-28 15:48:40', '2025-11-28 15:48:40'),
('285', 'PROD-000285', NULL, NULL, NULL, NULL, '0', 'Jabón de baño Anita', '0.00', '0.00', 'Jabón de baño Anita', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '1', '5', '23', '2025-11-28 15:50:29', '2025-11-28 15:50:29'),
('286', 'PROD-000286', NULL, NULL, NULL, NULL, '0', 'DETERGENTE OSO BLANCO ', '0.00', '0.00', 'DETERGENTE OSO BLANCO', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '1', '5', '24', '2025-11-28 15:53:05', '2025-11-28 15:53:05'),
('287', 'PROD-000287', NULL, NULL, NULL, NULL, '0', 'LAVAPLATOS TAPA AMARILLA', '0.00', '0.00', 'Lavaplatos en gel', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '1', '11', '45', '2025-11-28 16:04:21', '2025-11-28 16:04:21'),
('288', 'PROD-000288', NULL, NULL, NULL, NULL, '0', 'Boka Bebidas Instantáneas De Frutas', '0.00', '0.00', 'Boka Bebidas Instantáneas
', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '0', '0', '1', '1', '1', '6', '11', '2025-11-28 17:18:14', '2025-11-28 17:18:14');


-- Estructura de tabla `referencias_bancarias`
DROP TABLE IF EXISTS `referencias_bancarias`;
CREATE TABLE `referencias_bancarias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `tipo_pago` enum('pago_movil','transferencia') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `banco_id` bigint unsigned NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_cuenta` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_cuenta` enum('ahorro','corriente') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `monto_efectivo` decimal(10,2) DEFAULT NULL,
  `monto_restante` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `referencias_bancarias_pedido_id_foreign` (`pedido_id`),
  KEY `referencias_bancarias_banco_id_foreign` (`banco_id`),
  CONSTRAINT `referencias_bancarias_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `bancos` (`id`),
  CONSTRAINT `referencias_bancarias_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla referencias_bancarias: Sin datos en el rango de fechas


-- Estructura de tabla `resenas`
DROP TABLE IF EXISTS `resenas`;
CREATE TABLE `resenas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `calificacion` tinyint unsigned NOT NULL COMMENT '1-5 estrellas',
  `comentario` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `aprobada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resenas_user_id_foreign` (`user_id`),
  KEY `resenas_producto_id_foreign` (`producto_id`),
  KEY `resenas_pedido_id_producto_id_index` (`pedido_id`,`producto_id`),
  KEY `resenas_calificacion_index` (`calificacion`),
  KEY `resenas_aprobada_index` (`aprobada`),
  CONSTRAINT `resenas_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla resenas: Sin datos en el rango de fechas


-- Estructura de tabla `reunions`
DROP TABLE IF EXISTS `reunions`;
CREATE TABLE `reunions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `fecha_inicio` datetime NOT NULL,
  `fecha_fin` datetime NOT NULL,
  `ubicacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` enum('programada','en_curso','finalizada','cancelada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'programada',
  `color` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#007bff',
  `participantes` json DEFAULT NULL,
  `creado_por` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reunions_creado_por_foreign` (`creado_por`),
  KEY `reunions_empresa_id_foreign` (`empresa_id`),
  KEY `reunions_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `reunions_creado_por_foreign` FOREIGN KEY (`creado_por`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla reunions: Sin datos en el rango de fechas


-- Estructura de tabla `reviews`
DROP TABLE IF EXISTS `reviews`;
CREATE TABLE `reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` int unsigned NOT NULL DEFAULT '5',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_empresa_id_foreign` (`empresa_id`),
  KEY `reviews_producto_id_approved_index` (`producto_id`,`approved`),
  KEY `reviews_user_id_index` (`user_id`),
  CONSTRAINT `reviews_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla reviews: Sin datos en el rango de fechas


-- Estructura de tabla `role_has_permissions`
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla role_has_permissions: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `role_has_permissions` (completo)
TRUNCATE TABLE `role_has_permissions`;
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
('1', '1'),
('2', '1'),
('3', '1'),
('4', '1'),
('5', '1'),
('6', '1'),
('7', '1'),
('8', '1'),
('9', '1'),
('10', '1'),
('11', '1'),
('12', '1'),
('13', '1'),
('14', '1'),
('15', '1'),
('16', '1'),
('17', '1'),
('18', '1'),
('19', '1'),
('20', '1'),
('21', '1'),
('22', '1'),
('23', '1'),
('24', '1'),
('25', '1'),
('26', '1'),
('27', '1'),
('28', '1'),
('29', '1'),
('30', '1'),
('31', '1'),
('32', '1'),
('33', '1'),
('34', '1'),
('35', '1'),
('36', '1'),
('37', '1'),
('38', '1'),
('39', '1'),
('40', '1'),
('41', '1'),
('42', '1'),
('43', '1'),
('44', '1'),
('45', '1'),
('46', '1'),
('47', '1'),
('48', '1'),
('49', '1'),
('50', '1'),
('51', '1'),
('52', '1'),
('53', '1'),
('54', '1'),
('55', '1'),
('56', '1'),
('57', '1'),
('58', '1'),
('59', '1'),
('60', '1'),
('61', '1'),
('62', '1'),
('63', '1'),
('64', '1'),
('65', '1'),
('66', '1'),
('67', '1'),
('68', '1'),
('69', '1'),
('70', '1'),
('71', '1'),
('72', '1'),
('73', '1'),
('74', '1'),
('75', '1'),
('76', '1'),
('77', '1'),
('78', '1'),
('79', '1'),
('80', '1'),
('81', '1'),
('82', '1'),
('83', '1'),
('84', '1'),
('85', '1'),
('86', '1'),
('87', '1'),
('88', '1'),
('89', '1'),
('90', '1'),
('91', '1'),
('92', '1'),
('93', '1'),
('94', '1'),
('95', '1'),
('96', '1'),
('97', '1'),
('98', '1'),
('99', '1'),
('100', '1'),
('101', '1'),
('102', '1'),
('103', '1'),
('104', '1'),
('105', '1'),
('106', '1'),
('107', '1'),
('108', '1'),
('109', '1'),
('110', '1'),
('111', '1'),
('112', '1'),
('113', '1'),
('114', '1'),
('115', '1'),
('116', '1'),
('117', '1'),
('118', '1'),
('119', '1'),
('120', '1'),
('121', '1'),
('122', '1'),
('123', '1'),
('124', '1'),
('125', '1'),
('126', '1'),
('127', '1'),
('128', '1'),
('129', '1'),
('130', '1'),
('131', '1'),
('132', '1'),
('133', '1'),
('134', '1'),
('135', '1'),
('136', '1'),
('137', '1'),
('138', '1'),
('139', '1'),
('140', '1'),
('141', '1'),
('142', '1'),
('143', '1'),
('144', '1'),
('145', '1'),
('146', '1'),
('147', '1'),
('148', '1'),
('149', '1'),
('150', '1'),
('151', '1'),
('152', '1'),
('153', '1'),
('154', '1'),
('155', '1'),
('156', '1'),
('157', '1'),
('158', '1'),
('159', '1'),
('160', '1'),
('161', '1'),
('162', '1'),
('163', '1'),
('164', '1'),
('165', '1'),
('166', '1'),
('167', '1'),
('168', '1'),
('169', '1'),
('170', '1'),
('171', '1'),
('172', '1'),
('173', '1'),
('1', '2'),
('2', '2'),
('3', '2'),
('4', '2'),
('5', '2'),
('6', '2'),
('7', '2'),
('8', '2'),
('9', '2'),
('10', '2'),
('11', '2'),
('12', '2'),
('13', '2'),
('14', '2'),
('15', '2'),
('16', '2'),
('17', '2'),
('18', '2'),
('19', '2'),
('20', '2'),
('22', '2'),
('23', '2'),
('24', '2'),
('25', '2'),
('27', '2'),
('28', '2'),
('29', '2'),
('30', '2'),
('31', '2'),
('32', '2'),
('33', '2'),
('34', '2'),
('35', '2'),
('36', '2'),
('37', '2'),
('38', '2'),
('39', '2'),
('40', '2'),
('41', '2'),
('42', '2'),
('43', '2'),
('44', '2'),
('45', '2'),
('46', '2'),
('47', '2'),
('48', '2'),
('49', '2'),
('50', '2'),
('51', '2'),
('52', '2'),
('53', '2'),
('54', '2'),
('55', '2'),
('56', '2'),
('57', '2'),
('58', '2'),
('59', '2'),
('60', '2'),
('61', '2'),
('62', '2'),
('63', '2'),
('64', '2'),
('65', '2'),
('66', '2'),
('67', '2'),
('68', '2'),
('69', '2'),
('70', '2'),
('71', '2'),
('72', '2'),
('73', '2'),
('74', '2'),
('75', '2'),
('76', '2'),
('77', '2'),
('78', '2'),
('79', '2'),
('80', '2'),
('81', '2'),
('82', '2'),
('83', '2'),
('84', '2'),
('85', '2'),
('86', '2'),
('87', '2'),
('88', '2'),
('89', '2'),
('90', '2'),
('91', '2'),
('92', '2'),
('93', '2'),
('94', '2'),
('95', '2'),
('96', '2'),
('97', '2'),
('98', '2'),
('99', '2'),
('100', '2'),
('101', '2'),
('102', '2'),
('103', '2'),
('104', '2'),
('105', '2'),
('106', '2'),
('107', '2'),
('108', '2'),
('109', '2'),
('110', '2'),
('111', '2'),
('112', '2'),
('113', '2'),
('114', '2'),
('115', '2'),
('116', '2'),
('117', '2'),
('118', '2'),
('119', '2'),
('120', '2'),
('121', '2'),
('122', '2'),
('123', '2'),
('124', '2'),
('125', '2'),
('126', '2'),
('127', '2'),
('128', '2'),
('129', '2'),
('130', '2'),
('131', '2'),
('132', '2'),
('133', '2'),
('134', '2'),
('135', '2'),
('136', '2'),
('137', '2'),
('138', '2'),
('139', '2'),
('140', '2'),
('141', '2'),
('142', '2'),
('143', '2'),
('144', '2'),
('145', '2'),
('146', '2'),
('147', '2'),
('148', '2'),
('149', '2'),
('150', '2'),
('151', '2'),
('152', '2'),
('153', '2'),
('154', '2'),
('155', '2'),
('156', '2'),
('157', '2'),
('158', '2'),
('159', '2'),
('160', '2'),
('161', '2'),
('162', '2'),
('163', '2'),
('164', '2'),
('165', '2'),
('166', '2'),
('167', '2'),
('168', '2'),
('169', '2'),
('170', '2'),
('171', '2'),
('172', '2'),
('173', '2'),
('43', '3'),
('44', '3'),
('45', '3'),
('46', '3'),
('47', '3'),
('48', '3'),
('49', '3'),
('50', '3'),
('69', '3'),
('70', '3'),
('71', '3'),
('72', '3'),
('73', '3'),
('74', '3'),
('75', '3'),
('76', '3'),
('77', '3'),
('78', '3'),
('79', '3'),
('137', '4'),
('138', '4'),
('139', '4'),
('140', '4'),
('141', '4'),
('142', '4'),
('143', '4'),
('144', '4'),
('145', '4'),
('146', '4'),
('147', '4'),
('148', '4'),
('149', '4'),
('150', '4'),
('151', '4'),
('137', '5'),
('138', '5'),
('139', '5'),
('140', '5'),
('141', '5'),
('142', '5'),
('143', '5'),
('144', '5'),
('145', '5'),
('146', '5'),
('147', '5'),
('148', '5'),
('149', '5');


-- Estructura de tabla `roles`
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla roles: Sin datos en el rango de fechas


-- Estructura de tabla `series`
DROP TABLE IF EXISTS `series`;
CREATE TABLE `series` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tipo_documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `correlativo_actual` int NOT NULL DEFAULT '0',
  `longitud_correlativo` int NOT NULL DEFAULT '8',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series_serie_empresa_id_sucursal_id_unique` (`serie`,`empresa_id`,`sucursal_id`),
  KEY `series_empresa_id_foreign` (`empresa_id`),
  KEY `series_sucursal_id_foreign` (`sucursal_id`),
  KEY `series_tipo_documento_empresa_id_sucursal_id_activo_index` (`tipo_documento`,`empresa_id`,`sucursal_id`,`activo`),
  CONSTRAINT `series_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `series_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `series` (filtrado)
TRUNCATE TABLE `series`;
INSERT INTO `series` (`id`, `tipo_documento`, `serie`, `correlativo_actual`, `longitud_correlativo`, `activo`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
('1', 'factura', '10', '0', '8', '1', '1', '1', '2025-11-26 10:20:03', '2025-11-28 17:02:48');


-- Estructura de tabla `sessions`
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla sessions: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `sessions` (completo)
TRUNCATE TABLE `sessions`;
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
('dV2SvwMOFYliRlsrR4Sny0X1TPRMloC3fNHyMFGh', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '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', '1764361524'),
('h0hG8piRDqkKej066xgAKzE5lpluwkxX8X9i65JA', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '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', '1764361524'),
('OUyPVEl0vnicHKImEVAAvmMztayChXzCHyPG95FR', '2', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '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', '1764364971');


-- Estructura de tabla `sucursales`
DROP TABLE IF EXISTS `sucursales`;
CREATE TABLE `sucursales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sucursales_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `sucursales_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla sucursales: Sin datos en el rango de fechas


-- Estructura de tabla `template_customizations`
DROP TABLE IF EXISTS `template_customizations`;
CREATE TABLE `template_customizations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `primary_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#7367F0',
  `skin` int NOT NULL DEFAULT '0',
  `theme` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `semi_dark` tinyint(1) NOT NULL DEFAULT '0',
  `content_layout` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'compact',
  `header_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `menu_collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `navbar_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sticky',
  `text_direction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ltr',
  `footer_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `dropdown_on_hover` tinyint(1) NOT NULL DEFAULT '0',
  `layout_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'vertical',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla template_customizations: Sin datos en el rango de fechas


-- Estructura de tabla `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `bio` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notifications_email` tinyint(1) NOT NULL DEFAULT '1',
  `notifications_sms` tinyint(1) NOT NULL DEFAULT '0',
  `notifications_push` tinyint(1) NOT NULL DEFAULT '1',
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verification_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `two_factor_recovery_codes` json DEFAULT NULL,
  `two_factor_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `verification_code_sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `empresa_id` bigint unsigned DEFAULT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_devices` json DEFAULT NULL,
  `common_locations` json DEFAULT NULL,
  `total_session_time` int NOT NULL DEFAULT '0',
  `security_alerts` json DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `api_token` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_api_token_unique` (`api_token`),
  KEY `users_empresa_id_foreign` (`empresa_id`),
  KEY `users_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `users_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `users_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla users: Sin datos en el rango de fechas


-- Estructura de tabla `wishlists`
DROP TABLE IF EXISTS `wishlists`;
CREATE TABLE `wishlists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL DEFAULT '1',
  `user_id` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wishlists_user_id_producto_id_unique` (`user_id`,`producto_id`),
  KEY `wishlists_producto_id_foreign` (`producto_id`),
  CONSTRAINT `wishlists_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wishlists_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla wishlists: Sin datos en el rango de fechas


-- Rehabilitar verificación de llaves foráneas
COMMIT;
SET FOREIGN_KEY_CHECKS = 1;
