-- Respaldo filtrado por fechas (2025-11-28 a 2025-11-28)
-- Generado: 2025-11-28 12:19:05


-- Estructura de tabla `images`
DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '0',
  `producto_id` bigint unsigned NOT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `images_producto_id_foreign` (`producto_id`),
  KEY `images_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `images_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `images_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `images` (filtrado por created_at OR updated_at)
INSERT INTO `images` VALUES
('55', 'productos/1764337416_0.jpg', NULL, NULL, '0', '0', '42', '1', '1', '2025-11-28 09:43:36', '2025-11-28 09:43:36'),
('58', 'productos/1764337767_0.jpg', NULL, NULL, '0', '0', '43', '1', '1', '2025-11-28 09:49:27', '2025-11-28 09:49:27'),
('59', 'productos/1764337943_0.jpg', NULL, NULL, '0', '0', '44', '1', '1', '2025-11-28 09:52:23', '2025-11-28 09:52:23'),
('60', 'productos/1764338134_0.jpg', NULL, NULL, '0', '0', '46', '1', '1', '2025-11-28 09:55:34', '2025-11-28 09:55:34'),
('61', 'productos/1764338160_0.jpg', NULL, NULL, '0', '0', '47', '1', '1', '2025-11-28 09:56:00', '2025-11-28 09:56:00'),
('62', 'productos/1764338245_0.jpg', NULL, NULL, '0', '0', '48', '1', '1', '2025-11-28 09:57:25', '2025-11-28 09:57:25'),
('64', 'productos/1764338349_0.webp', NULL, NULL, '0', '0', '50', '1', '1', '2025-11-28 09:59:09', '2025-11-28 09:59:09'),
('65', 'productos/1764338526_0.jpg', NULL, NULL, '0', '0', '51', '1', '1', '2025-11-28 10:02:06', '2025-11-28 10:02:06'),
('66', 'productos/i4x5dqeFlSrw5alZ3YeEuL7RZ56EKJiY4ktApYB9.jpg', NULL, 'Cigarrillos Consul', '0', '0', '272', '0', '1', '2025-11-28 10:41:40', '2025-11-28 10:41:40'),
('67', 'productos/1764340900_0.jpg', NULL, NULL, '0', '0', '272', '1', '1', '2025-11-28 10:41:40', '2025-11-28 10:41:40'),
('68', 'productos/1764341410_0.jpg', NULL, NULL, '0', '0', '273', '1', '1', '2025-11-28 10:50:10', '2025-11-28 10:50:10'),
('69', 'productos/1764342731_0.jpg', NULL, NULL, '0', '0', '60', '1', '1', '2025-11-28 11:12:11', '2025-11-28 11:12:11'),
('70', 'productos/1764343424_0.jpg', NULL, NULL, '0', '0', '61', '1', '1', '2025-11-28 11:23:44', '2025-11-28 11:23:44'),
('71', 'productos/1764343479_0.jpg', NULL, NULL, '0', '0', '63', '1', '1', '2025-11-28 11:24:39', '2025-11-28 11:24:39'),
('72', 'productos/1764343555_0.jpg', NULL, NULL, '0', '0', '59', '1', '1', '2025-11-28 11:25:55', '2025-11-28 11:25:55'),
('73', 'productos/1764343834_0.jpg', NULL, NULL, '0', '0', '58', '1', '1', '2025-11-28 11:30:34', '2025-11-28 11:30:34'),
('74', 'productos/1764344060_0.jpg', NULL, NULL, '0', '0', '66', '1', '1', '2025-11-28 11:34:21', '2025-11-28 11:34:21'),
('75', 'productos/1764345114_0.jpg', NULL, NULL, '0', '0', '200', '1', '1', '2025-11-28 11:51:54', '2025-11-28 11:51:54'),
('76', 'productos/1764345151_0.jpg', NULL, NULL, '0', '0', '201', '1', '1', '2025-11-28 11:52:31', '2025-11-28 11:52:31'),
('77', 'productos/1764345185_0.jpg', NULL, NULL, '0', '0', '202', '1', '1', '2025-11-28 11:53:05', '2025-11-28 11:53:05'),
('78', 'productos/1764345261_0.jpg', NULL, NULL, '0', '0', '185', '1', '1', '2025-11-28 11:54:21', '2025-11-28 11:54:21'),
('79', 'productos/1764345290_0.jpg', NULL, NULL, '0', '0', '186', '1', '1', '2025-11-28 11:54:50', '2025-11-28 11:54:50');


-- Estructura de tabla `product_batches`
DROP TABLE IF EXISTS `product_batches`;
CREATE TABLE `product_batches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `batch_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `initial_quantity` int NOT NULL,
  `current_quantity` int NOT NULL,
  `manufacturing_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `supplier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_unit` decimal(10,2) DEFAULT NULL,
  `status` enum('active','expired','recalled','sold_out') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_batches_empresa_id_foreign` (`empresa_id`),
  KEY `product_batches_producto_id_batch_number_index` (`producto_id`,`batch_number`),
  KEY `product_batches_expiry_date_status_index` (`expiry_date`,`status`),
  CONSTRAINT `product_batches_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `product_batches_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla product_batches: Sin datos en el rango de fechas


-- Estructura de tabla `product_reviews`
DROP TABLE IF EXISTS `product_reviews`;
CREATE TABLE `product_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` tinyint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `verified_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_reviews_producto_id_user_id_unique` (`producto_id`,`user_id`),
  KEY `product_reviews_user_id_foreign` (`user_id`),
  KEY `product_reviews_producto_id_is_approved_index` (`producto_id`,`is_approved`),
  CONSTRAINT `product_reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla product_reviews: Sin datos en el rango de fechas


-- Estructura de tabla `producto_inventory_settings`
DROP TABLE IF EXISTS `producto_inventory_settings`;
CREATE TABLE `producto_inventory_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `low_stock_threshold` int NOT NULL DEFAULT '5',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_inventory_settings_producto_id_index` (`producto_id`),
  KEY `producto_inventory_settings_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_inventory_settings_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_inventory_settings_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_inventory_settings` (filtrado por created_at OR updated_at)
INSERT INTO `producto_inventory_settings` VALUES
('1', '272', '1', '0', 'deny', '5', '1', '2025-11-28 10:41:40', '2025-11-28 10:43:10');


-- Estructura de tabla `producto_seo`
DROP TABLE IF EXISTS `producto_seo`;
CREATE TABLE `producto_seo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_seo_producto_id_index` (`producto_id`),
  KEY `producto_seo_empresa_id_index` (`empresa_id`),
  KEY `producto_seo_sku_index` (`sku`),
  KEY `producto_seo_barcode_index` (`barcode`),
  CONSTRAINT `producto_seo_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_seo_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_seo` (filtrado por created_at OR updated_at)
INSERT INTO `producto_seo` VALUES
('11', '42', 'CHIMO-EL-APURENO-IZGI', '', '', '', '', '0', '1', '2025-11-28 09:43:04', '2025-11-28 09:43:36'),
('12', '43', 'CHIMO-EL-TIGRITO-AMARILLO-DZIS', '', '', '', '', '0', '1', '2025-11-28 09:44:56', '2025-11-28 09:44:56'),
('13', '44', 'CIGARRILLOS-NOVA-LUCKY-STRIKE-SUTS', '', '', '', '', '0', '1', '2025-11-28 09:52:23', '2025-11-28 09:52:23'),
('14', '46', 'CIGARROS-ECLIPSE-LUCKY-STRIKE-JD8V', '', '', '', '', '0', '1', '2025-11-28 09:55:34', '2025-11-28 09:55:34'),
('15', '47', 'CIGARROS-10UND-BELMONT-3RYX', '', '', '', '', '0', '1', '2025-11-28 09:56:00', '2025-11-28 09:56:00'),
('16', '271', '', '', '', '', '', '0', '1', '2025-11-28 09:56:48', '2025-11-28 09:56:48'),
('17', '48', 'CIGARROS-20UND-BELMONT-YZCD', '', '', '', '', '0', '1', '2025-11-28 09:57:25', '2025-11-28 09:57:25'),
('19', '50', 'CIGARROS-VICEROY-12PP', '', '', '', '', '0', '1', '2025-11-28 09:59:09', '2025-11-28 09:59:09'),
('20', '51', 'CIGARROS-20UND-UNIVERSAL-QUXC', '', '', '', '', '0', '1', '2025-11-28 10:02:06', '2025-11-28 10:02:06'),
('21', '272', 'CIGARRILLOS-CONSUL-4PJP', '', '', '', '', '0', '1', '2025-11-28 10:41:40', '2025-11-28 10:43:10'),
('22', '273', 'CIGARRILLOS-PALL-MALL-ZZTR', '', '', '', '', '0', '1', '2025-11-28 10:50:10', '2025-11-28 10:50:10'),
('23', '60', 'PRINGLES-QUESO-CHEDDAR-DHDD', '', '', '', '', '0', '1', '2025-11-28 11:12:11', '2025-11-28 11:12:11'),
('24', '61', 'PRINGLES-BARBACOA-BBQ-GAVH', '', '', '', '', '0', '1', '2025-11-28 11:23:44', '2025-11-28 11:23:44'),
('25', '63', 'PRINGLES-PIZZA-QAVT', '', '', '', '', '0', '1', '2025-11-28 11:24:39', '2025-11-28 11:24:39'),
('26', '59', 'PRINGLES-CREMA-Y-CEBOLLA-9TGM', '', '', '', '', '0', '1', '2025-11-28 11:25:55', '2025-11-28 11:25:55'),
('27', '58', 'PRINGLES-ORIGINAL-GVGB', '', '', '', '', '0', '1', '2025-11-28 11:30:34', '2025-11-28 11:30:34'),
('28', '66', 'TOSTONES-CON-AJO-TOM-ZVZI', '', '', '', '', '0', '1', '2025-11-28 11:34:21', '2025-11-28 11:34:21'),
('29', '200', 'GATORADE-AZUL-8XC0', '', '', '', '', '0', '1', '2025-11-28 11:51:54', '2025-11-28 11:51:54'),
('30', '201', 'GATORADE-MANDARINA-EZMH', '', '', '', '', '0', '1', '2025-11-28 11:52:31', '2025-11-28 11:52:31'),
('31', '202', 'GATORADE-TROPICAL-UVHH', '', '', '', '', '0', '1', '2025-11-28 11:53:05', '2025-11-28 11:53:05'),
('32', '185', 'JUGO-SPEED-KBUD', '', '', '', '', '0', '1', '2025-11-28 11:54:21', '2025-11-28 11:54:21'),
('33', '186', 'JUGO-SPEED-LATA-6B2X', '', '', '', '', '0', '1', '2025-11-28 11:54:50', '2025-11-28 11:54:50');


-- Estructura de tabla `producto_variants`
DROP TABLE IF EXISTS `producto_variants`;
CREATE TABLE `producto_variants` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `values` json NOT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_adjustment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `image_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_thumbnail_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_variants_producto_id_index` (`producto_id`),
  KEY `producto_variants_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_variants_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_variants_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_variants` (filtrado por created_at OR updated_at)
INSERT INTO `producto_variants` VALUES
('72', '42', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CHIMO-EL-APURENO-IZGI', '0.00', '0.00', '1000', NULL, NULL, 'Cantidad: 1 und - Chimo el apureño', '1', '2025-11-21 01:13:56', '2025-11-28 09:56:26'),
('73', '43', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CHIMO-EL-TIGRITO-AMARILLO-DZIS', '0.00', '0.00', '200', NULL, NULL, 'Cantidad: 1 und - Chimo El Tigrito Amarillo', '1', '2025-11-21 01:13:56', '2025-11-28 09:49:27'),
('74', '44', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CIGARRILLOS-NOVA-LUCKY-STRIKE-SUTS', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 1 und - Cigarrillos Nova Lucky Strike Cosmic', '1', '2025-11-21 01:13:56', '2025-11-28 09:52:23'),
('76', '46', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CIGARROS-ECLIPSE-LUCKY-STRIKE-JD8V', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 1 und - Cigarros Eclipse Lucky Strike', '1', '2025-11-21 01:13:56', '2025-11-28 09:55:34'),
('77', '47', 'Cantidad: 10 und', '{\"Cantidad: 10 und\": \"10 und\"}', 'CIGARROS-10UND-BELMONT-3RYX', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 10 und - Cigarros 10und Belmont', '1', '2025-11-21 01:13:56', '2025-11-28 09:56:00'),
('78', '48', 'Cantidad: 20 und', '{\"Cantidad: 20 und\": \"20 und\"}', 'CIGARROS-20UND-BELMONT-YZCD', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 20 und - Cigarros 20und Belmont', '1', '2025-11-21 01:13:56', '2025-11-28 09:57:25'),
('80', '50', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CIGARROS-VICEROY-12PP', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 1 und - Cigarros Viceroy', '1', '2025-11-21 01:13:56', '2025-11-28 09:59:09'),
('81', '51', 'Cantidad: 20 und', '{\"Cantidad: 20 und\": \"20 und\"}', 'CIGARROS-20UND-UNIVERSAL-QUXC', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 20 und - Cigarros 20und Universal', '1', '2025-11-21 01:13:56', '2025-11-28 10:02:06'),
('88', '58', 'peso', '{\"Peso\": \"100g\"}', 'PRINGLES-ORIGINAL-GVGB', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Original', '1', '2025-11-21 01:13:56', '2025-11-28 11:31:40'),
('90', '59', 'peso', '{\"Peso\": \"110g\"}', 'PRINGLES-CREMA-Y-CEBOLLA-9TGM', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Crema y Cebolla', '1', '2025-11-21 01:13:56', '2025-11-28 11:29:53'),
('92', '60', 'peso', '{\"Peso\": \"110g\"}', 'PRINGLES-QUESO-CHEDDAR-DHDD', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Queso Cheddar', '1', '2025-11-21 01:13:57', '2025-11-28 11:14:02'),
('94', '61', 'peso', '{\"Peso\": \"110g, 100g\"}', 'PRINGLES-BARBACOA-BBQ-GAVH', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Barbacoa BBQ', '1', '2025-11-21 01:13:57', '2025-11-28 11:27:37'),
('98', '63', 'peso', '{\"Peso\": \"110g\"}', 'PRINGLES-PIZZA-QAVT', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Pizza', '1', '2025-11-21 01:13:57', '2025-11-28 11:28:51'),
('250', '185', 'volumen', '{\"Volumen\": \"1L\"}', 'JUGO-SPEED-KBUD', '0.00', '0.00', '70', NULL, NULL, 'Volumen: 1LT - Jugo Speed', '1', '2025-11-21 01:13:57', '2025-11-28 11:57:27'),
('406', '272', 'unidades', '{\"Unidades\": \"20 unidades\"}', 'CIGARRILLOS-CONSUL-4PJP', '0.00', '0.00', '5000', NULL, NULL, '', '1', '2025-11-28 10:41:40', '2025-11-28 10:43:10'),
('407', '273', 'unidades', '{\"Unidades\": \"20 unidades\"}', 'CIGARRILLOS-PALL-MALL-ZZTR', '0.00', '0.00', '0', 'productos/1764342336_variant_0.jpg', 'productos/thumb_1764342336_variant_0.jpg', '', '1', '2025-11-28 10:50:11', '2025-11-28 11:05:36'),
('408', '273', 'unidades', '{\"Unidades\": \"10 unidades\"}', 'CIGARRILLOS-PALL-MALL-ZZTR', '0.00', '0.00', '0', 'productos/1764341758_variant_1.jpg', 'productos/thumb_1764341758_variant_1.jpg', '', '1', '2025-11-28 10:54:01', '2025-11-28 11:05:36'),
('409', '60', 'peso', '\"{\\\"Peso\\\":\\\"71g\\\"}\"', 'PRINGLES-QUESO-CHEDDAR-DHDD', '0.00', '0.00', '0', 'productos/1764342842_variant_1.jpg', 'productos/thumb_1764342842_variant_1.jpg', '', '1', '2025-11-28 11:14:02', '2025-11-28 11:14:02'),
('410', '61', 'peso', '\"{\\\"Peso\\\":\\\"71g\\\"}\"', 'PRINGLES-BARBACOA-BBQ-GAVH', '0.00', '0.00', '0', 'productos/1764343657_variant_1.jpg', 'productos/thumb_1764343657_variant_1.jpg', '', '1', '2025-11-28 11:27:37', '2025-11-28 11:27:37'),
('411', '59', 'peso', '\"{\\\"Peso\\\":\\\"71g\\\"}\"', 'PRINGLES-CREMA-Y-CEBOLLA-9TGM', '0.00', '0.00', '0', 'productos/1764343793_variant_1.jpg', 'productos/thumb_1764343793_variant_1.jpg', '', '1', '2025-11-28 11:29:53', '2025-11-28 11:29:53'),
('412', '58', 'peso', '{\"Peso\": \"71g\"}', 'PRINGLES-ORIGINAL-GVGB', '0.00', '0.00', '0', 'productos/1764343873_variant_1.jpg', 'productos/thumb_1764343873_variant_1.jpg', '', '1', '2025-11-28 11:31:13', '2025-11-28 11:31:40'),
('413', '66', 'peso', '{\"Peso\": \"140g\"}', 'TOSTONES-CON-AJO-TOM-ZVZI', '0.00', '0.00', '0', NULL, NULL, '', '1', '2025-11-28 11:34:21', '2025-11-28 11:38:08'),
('414', '66', 'peso', '{\"Peso\": \"28g\"}', 'TOSTONES-CON-AJO-TOM-ZVZI', '7.00', '8.00', '0', 'productos/1764344177_variant_1.jpg', 'productos/thumb_1764344177_variant_1.jpg', '', '1', '2025-11-28 11:36:17', '2025-11-28 11:38:08');


-- Estructura de tabla `productos`
DROP TABLE IF EXISTS `productos`;
CREATE TABLE `productos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `batch_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `requires_batch_tracking` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `has_variants` tinyint(1) NOT NULL DEFAULT '0',
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `quantity` int NOT NULL DEFAULT '0',
  `quantity_alert` int NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `categoria_id` bigint unsigned NOT NULL,
  `marca_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `productos_code_unique` (`code`),
  KEY `productos_empresa_id_index` (`empresa_id`),
  KEY `productos_categoria_id_index` (`categoria_id`),
  KEY `productos_marca_id_index` (`marca_id`),
  KEY `productos_name_index` (`name`),
  KEY `productos_price_index` (`price`),
  KEY `productos_quantity_index` (`quantity`),
  KEY `productos_status_quantity_index` (`status`,`quantity`),
  CONSTRAINT `productos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_marca_id_foreign` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `productos` (filtrado por created_at OR updated_at)
INSERT INTO `productos` VALUES
('11', 'SAL-71890', NULL, NULL, NULL, NULL, '0', 'Salsa de Tomate', '1.50', '52.50', 'Salsa de tomate tradicional', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '90', '10', '0', '1', '1', '1', '2025-11-21 01:13:56', '2025-11-28 11:32:47'),
('38', 'ARR-64433', NULL, NULL, NULL, NULL, '0', 'Arroz Blanco Pringles', '2.60', '91.00', 'Arroz blanco de alta calidad', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '13', '2025-11-21 01:13:56', '2025-11-28 11:24:58'),
('39', 'HAR-69736', NULL, NULL, NULL, NULL, '0', 'Harina de Maíz Precocida Pringles', '2.30', '80.50', 'Harina de maíz precocida para arepas', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '13', '2025-11-21 01:13:56', '2025-11-28 11:25:03'),
('40', 'ARR-98862', NULL, NULL, NULL, NULL, '0', 'Arroz Blanco Tom', '2.70', '94.50', 'Arroz blanco de alta calidad', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '14', '2025-11-21 01:13:56', '2025-11-28 11:32:47'),
('41', 'HAR-27341', NULL, NULL, NULL, NULL, '0', 'Harina de Maíz Precocida Tom', '2.40', '84.00', 'Harina de maíz precocida para arepas', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '14', '2025-11-21 01:13:56', '2025-11-28 11:32:48'),
('44', 'CIG-75268', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Nova Lucky Strike', '3.65', '127.75', 'Cigarrillos Nova Lucky Strike (COSMIC)', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '1', '1', '2', '15', '2025-11-21 01:13:56', '2025-11-28 09:52:23'),
('45', 'CIG-10525', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Lucky Strike Red', '3.39', '118.65', 'Cigarrillos Lucky Strike Red', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '2', '15', '2025-11-21 01:13:56', '2025-11-28 09:55:16'),
('60', 'PRI-79083', NULL, NULL, NULL, NULL, '0', 'Pringles Queso Cheddar', '2.50', '87.50', 'Papas fritas sabor queso cheddar', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '1', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:12:11'),
('61', 'PRI-61948', NULL, NULL, NULL, NULL, '0', 'Pringles Barbacoa BBQ', '2.50', '87.50', 'Papas fritas sabor barbacoa BBQ', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '1', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:24:10'),
('62', 'PRI-54900', NULL, NULL, NULL, NULL, '0', 'Pringles Ranch', '2.50', '87.50', 'Papas fritas sabor ranch en presentación de 110g', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '0', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:24:13'),
('63', 'PRI-81096', NULL, NULL, NULL, NULL, '0', 'Pringles Pizza', '2.50', '87.50', 'Papas fritas sabor a pizza ', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '1', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:28:51'),
('64', 'PRI-22822', NULL, NULL, NULL, NULL, '0', 'Pringles Enchilada', '2.70', '94.50', 'Papas fritas sabor enchilada en presentación de 124g', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:25:09'),
('65', 'PRI-25450', NULL, NULL, NULL, NULL, '0', 'Pringles Habanero', '2.70', '94.50', 'Papas fritas sabor habanero en presentación de 124g', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:24:59'),
('67', 'TOS-92373', NULL, NULL, NULL, NULL, '0', 'Tostones Natural Tom', '1.43', '50.05', 'Tostones naturales sin condimentos', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '300', '10', '0', '1', '3', '14', '2025-11-21 01:13:57', '2025-11-28 11:33:04'),
('213', 'DOR-12919', NULL, NULL, NULL, NULL, '0', 'Doritos Nacho Cheese', '2.25', '78.75', 'Tortilla chips sabor queso nacho', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '80', '10', '0', '1', '7', '28', '2025-11-21 01:13:57', '2025-11-28 11:22:03'),
('215', 'DOR-29446', NULL, NULL, NULL, NULL, '0', 'Doritos Mega Queso', '2.45', '85.75', 'Tortilla chips mega queso', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '70', '10', '0', '1', '7', '28', '2025-11-21 01:13:57', '2025-11-28 11:22:04'),
('216', 'CHE-78983', NULL, NULL, NULL, NULL, '0', 'Cheese Tris 50g', '1.25', '43.75', 'Snack de queso triangular', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '7', '56', '2025-11-21 01:13:57', '2025-11-28 11:22:08'),
('218', 'PUF-62852', NULL, NULL, NULL, NULL, '0', 'Puffy Sabor a Queso', '1.15', '40.25', 'Snack inflado sabor queso', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '90', '10', '0', '1', '7', '89', '2025-11-21 01:13:57', '2025-11-28 11:22:11'),
('219', 'PUF-10480', NULL, NULL, NULL, NULL, '0', 'Puffy Sabor a Tomate con Albahaca', '1.15', '40.25', 'Snack inflado sabor tomate albahaca', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '85', '10', '0', '1', '7', '89', '2025-11-21 01:13:57', '2025-11-28 11:32:46'),
('224', 'RUF-16260', NULL, NULL, NULL, NULL, '0', 'Ruffles Queso y Cebolla', '2.10', '73.50', 'Papas fritas onduladas sabor queso y cebolla', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '75', '10', '0', '1', '7', '30', '2025-11-21 01:13:57', '2025-11-28 11:22:15'),
('225', 'CHE-61807', NULL, NULL, NULL, NULL, '0', 'Cheetos Crunchy', '1.95', '68.25', 'Snacks de maíz sabor queso cheddar', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '85', '10', '0', '1', '7', '31', '2025-11-21 01:13:57', '2025-11-28 11:22:17'),
('230', 'RIT-86777', NULL, NULL, NULL, NULL, '0', 'Ritz Crackers Queso', '2.35', '82.25', 'Galletas saladas con sabor a queso', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '70', '10', '0', '1', '7', '33', '2025-11-21 01:13:57', '2025-11-28 11:22:18'),
('272', 'PROD-000272', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Consul', '0.00', '0.00', 'Cigarrillos Consul', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '2', '107', '2025-11-28 10:41:40', '2025-11-28 10:43:10'),
('273', 'PROD-1764341310', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Pall Mall', '0.00', '0.00', 'Cigarrillos Pall Mall', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '2', '18', '2025-11-28 10:48:30', '2025-11-28 10:50:10');

