<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Venta extends Model
{
    protected $fillable = [
        'codigo',
        'total',
        'total_usd',
        'total_bs',
        'metodo_pago',
        'estado',
        'tipo_documento',
        'numero_documento',
        'serie_id',
        'caja_id',
        'empresa_id',
        'sucursal_id',
        'user_id',
        'empleado_id',
        'cliente_id',
        'descuento',
        'impuesto',
        'observaciones',
        'nota_venta_id' // ID de la nota de venta origen
    ];

    protected $casts = [
        'total' => 'decimal:2',
        'total_usd' => 'decimal:2',
        'total_bs' => 'decimal:2',
        'descuento' => 'decimal:2',
        'impuesto' => 'decimal:2',
    ];

    public function detalles(): HasMany
    {
        return $this->hasMany(DetalleVenta::class);
    }

    public function pagos(): HasMany
    {
        return $this->hasMany(VentaPago::class);
    }

    public function serie(): BelongsTo
    {
        return $this->belongsTo(Serie::class);
    }

    public function caja(): BelongsTo
    {
        return $this->belongsTo(Caja::class);
    }

    public function empresa(): BelongsTo
    {
        return $this->belongsTo(Empresa::class);
    }

    public function usuario(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function empleado(): BelongsTo
    {
        return $this->belongsTo(User::class, 'empleado_id');
    }

    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function notaVenta(): BelongsTo
    {
        return $this->belongsTo(NotaVenta::class);
    }
}