<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ReferenciaBancaria extends Model
{
    use HasFactory;

    protected $table = 'referencias_bancarias';

    protected $fillable = [
        'pedido_id',
        'tipo_pago',
        'banco_id',
        'documento',
        'numero_telefono',
        'numero_cuenta',
        'tipo_cuenta',
        'referencia',
        'monto_efectivo',
        'monto_restante'
    ];

    public function pedido()
    {
        return $this->belongsTo(Pedido::class, 'pedido_id');
    }

    public function banco()
    {
        return $this->belongsTo(Banco::class);
    }
    
    /**
     * Get the pago that owns the ReferenciaBancaria
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function pedidoPago()
    {
        return $this->belongsTo(PedidoPago::class, 'id', 'referencia_bancaria_id');
    }
}