<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class ProductoVariant extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $table = 'producto_variants';

    protected $fillable = [
        'producto_id',
        'name',
        'values',
        'sku',
        'price_adjustment',
        'precio_bs',
        'quantity',
        'image_path',
        'image_thumbnail_path',
        'alt_text',
        'empresa_id'
    ];

    protected $casts = [
        'values' => 'array'
    ];

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function getFormattedValuesAttribute()
    {
        if (empty($this->values)) {
            return $this->name;
        }

        // Si values es un array, unir los valores con coma
        if (is_array($this->values)) {
            return implode(', ', $this->values);
        }

        // Si values es un string JSON, decodificarlo y unir los valores
        $decoded = json_decode($this->values, true);
        if (is_array($decoded)) {
            return implode(', ', $decoded);
        }

        return $this->values;
    }
}
