<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class ProductoSeo extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $table = 'producto_seo';

    protected $fillable = [
        'producto_id',
        'sku',
        'barcode',
        'meta_title',
        'meta_description',
        'tags',
        'featured',
        'empresa_id'
    ];

    protected $casts = [
        'featured' => 'boolean'
    ];

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
}
