<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;
use App\Traits\HasRegionalFormatting;

class NotaVenta extends Model
{
    use Multitenantable, HasRegionalFormatting;

    protected $table = 'notas_venta';

    protected $fillable = [
        'serie',
        'numero',
        'fecha_emision',
        'fecha_vencimiento',
        'cliente_id',
        'observaciones',
        'subtotal',
        'impuestos',
        'total',
        'estado',
        'empresa_id',
        'sucursal_id',
        'user_id',
        'codigo',
        'venta_id' // ID de la venta generada
    ];

    protected $casts = [
        'fecha_emision' => 'date',
        'fecha_vencimiento' => 'date',
        'subtotal' => 'decimal:2',
        'impuestos' => 'decimal:2',
        'total' => 'decimal:2'
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }

    public function detalles()
    {
        return $this->hasMany(DetalleNotaVenta::class);
    }

    public function cotizaciones()
    {
        return $this->hasMany(Cotizacion::class);
    }

    public function venta()
    {
        return $this->belongsTo(Venta::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getNumeroCompletoAttribute()
    {
        return $this->serie . '-' . str_pad($this->numero, 8, '0', STR_PAD_LEFT);
    }

    public static function getEstados()
    {
        return [
            'pendiente' => 'Pendiente',
            'procesada' => 'Procesada',
            'anulada' => 'Anulada'
        ];
    }
}
