<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Traits\Multitenantable;

class InventoryMovement extends Model
{
    use Multitenantable;

    protected $fillable = [
        'producto_id',
        'type',
        'quantity',
        'quantity_before',
        'quantity_after',
        'unit_cost',
        'total_cost',
        'reference',
        'notes',
        'user_id',
        'empresa_id',
        'sucursal_id'
    ];

    protected $casts = [
        'quantity' => 'integer',
        'quantity_before' => 'integer',
        'quantity_after' => 'integer',
        'unit_cost' => 'decimal:2',
        'total_cost' => 'decimal:2',
    ];

    public function producto(): BelongsTo
    {
        return $this->belongsTo(Producto::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function empresa(): BelongsTo
    {
        return $this->belongsTo(Empresa::class);
    }

    public function getTypeColorAttribute(): string
    {
        return match($this->type) {
            'ingreso', 'compra', 'devolucion' => 'success',
            'salida', 'venta' => 'danger',
            'ajuste' => 'warning',
            default => 'info'
        };
    }

    public function getTypeIconAttribute(): string
    {
        return match($this->type) {
            'ingreso', 'compra' => 'ri-add-circle-line',
            'salida', 'venta' => 'ri-subtract-line',
            'devolucion' => 'ri-arrow-go-back-line',
            'ajuste' => 'ri-settings-3-line',
            default => 'ri-information-line'
        };
    }
}