<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class Image extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $fillable = [
        'path',
        'thumbnail_path',
        'alt_text',
        'is_primary',
        'order',
        'producto_id',
        'featured',
        'empresa_id'
    ];

    protected $casts = [
        'featured' => 'boolean'
    ];

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
}
