<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class Empleado extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $fillable = [
        'codigo',
        'nombres',
        'apellidos',
        'documento',
        'tipo_documento',
        'email',
        'telefono',
        'fecha_nacimiento',
        'genero',
        'direccion',
        'cargo',
        'departamento',
        'salario',
        'fecha_ingreso',
        'fecha_salida',
        'estado_civil',
        'contacto_emergencia',
        'telefono_emergencia',
        'observaciones',
        'status',
        'empresa_id',
        'sucursal_id',
        'user_id'
    ];

    protected $casts = [
        'fecha_nacimiento' => 'date',
        'fecha_ingreso' => 'date',
        'fecha_salida' => 'date',
        'salario' => 'decimal:2',
        'status' => 'boolean'
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getNombreCompletoAttribute()
    {
        return $this->nombres . ' ' . $this->apellidos;
    }

    public function getEdadAttribute()
    {
        return $this->fecha_nacimiento ? $this->fecha_nacimiento->age : null;
    }

    public function getAntiguedadAttribute()
    {
        return $this->fecha_ingreso->diffInYears(now());
    }

    public function scopeActivos($query)
    {
        return $query->where('status', true);
    }

    public function scopeInactivos($query)
    {
        return $query->where('status', false);
    }
}