<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class DetallePedido extends Model
{
    protected $fillable = [
        'pedidoId',
        'productoId',
        'variant_id',
        'product_name',
        'quantity',
        'price',
        'total_usd',
        'total_bs',
        'fecha',
        'empresaId',
        'userId'
    ];

    protected $casts = [
        'quantity' => 'integer',
        'price' => 'decimal:20,2',
        'total_usd' => 'decimal:20,2',
        'total_bs' => 'decimal:20,2'
    ];

    // Accessors para asegurar que los valores sean numéricos
    public function getPriceAttribute($value)
    {
        return is_numeric($value) ? $value : 0;
    }

    public function getTotalUsdAttribute($value)
    {
        return is_numeric($value) ? $value : 0;
    }

    public function getTotalBsAttribute($value)
    {
        return is_numeric($value) ? $value : 0;
    }

    /**
     * Get the producto associated with the DetallePedido
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function producto(): BelongsTo
    {
        return $this->belongsTo(Producto::class, 'productoId', 'id');
    }

    /**
     * Get the pedido that owns the DetallePedido
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function pedido(): BelongsTo
    {
        return $this->belongsTo(Pedido::class, 'pedidoId', 'id');
    }

    /**
     * Get the variant associated with the DetallePedido
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function variant(): BelongsTo
    {
        return $this->belongsTo(ProductoVariant::class, 'variant_id', 'id');
    }


}
