<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class Categoria extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $fillable = [
        'nombre',
        'slug',
        'descripcion',
        'activo',
        'empresa_id',
        'sucursal_id'
    ];

    protected $casts = [
        'activo' => 'boolean'
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }

    public function productos()
    {
        return $this->hasMany(Producto::class);
    }
}
