<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;

class BatchMovement extends Model
{
    use Multitenantable;

    protected $fillable = [
        'batch_id', 'type', 'quantity', 'reference', 'reason', 'user_id', 'empresa_id'
    ];

    protected $casts = [
        'quantity' => 'integer'
    ];

    public function batch()
    {
        return $this->belongsTo(ProductBatch::class, 'batch_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
}