<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Banco extends Model
{
    use HasFactory;

    protected $table = 'bancos';

    protected $fillable = [
        'nombre',
        'codigo',
        'activo'
    ];

    protected $casts = [
        'activo' => 'boolean'
    ];

    public function scopeActivos($query)
    {
        return $query->where('activo', true);
    }
}