<?php

namespace App\Livewire\Tienda;

use App\Models\Producto;
use App\Models\Categoria;
use Livewire\Component;
use Livewire\WithPagination;

class Productos extends Component
{
    use WithPagination;

    public $search = '';
    public $categoria = '';
    public $precioMin = '';
    public $precioMax = '';
    public $ordenarPor = 'name';
    public $orden = 'asc';

    protected $queryString = [
        'search' => ['except' => ''],
        'categoria' => ['except' => ''],
        'precioMin' => ['except' => ''],
        'precioMax' => ['except' => ''],
        'ordenarPor' => ['except' => 'name'],
        'orden' => ['except' => 'asc'],
    ];

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingCategoria()
    {
        $this->resetPage();
    }

    public function updatingPrecioMin()
    {
        $this->resetPage();
    }

    public function updatingPrecioMax()
    {
        $this->resetPage();
    }

    public function aplicarFiltros()
    {
        $this->resetPage();
    }

    public function limpiarFiltros()
    {
        $this->search = '';
        $this->categoria = '';
        $this->precioMin = '';
        $this->precioMax = '';
        $this->resetPage();
    }

    public function render()
    {
        $query = Producto::with(['images', 'categoria'])
            ->where('status', true);

        // Aplicar búsqueda
        if ($this->search) {
            $query->where(function($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                  ->orWhere('descripcion', 'like', '%' . $this->search . '%');
            });
        }

        // Aplicar filtro de categoría
        if ($this->categoria) {
            $query->whereHas('categoria', function($q) {
                $q->where('name', $this->categoria);
            });
        }

        // Aplicar filtros de precio
        if ($this->precioMin) {
            $query->where('precio', '>=', $this->precioMin);
        }

        if ($this->precioMax) {
            $query->where('precio', '<=', $this->precioMax);
        }

        // Aplicar ordenamiento
        $query->orderBy($this->ordenarPor, $this->orden);

        $productos = $query->paginate(12);
        $categorias = Categoria::where('activo', true)->pluck('name');

        return view('livewire.tienda.productos', [
            'productos' => $productos,
            'categorias' => $categorias,
        ])->layout('layouts.tienda');
    }
}
