<?php

namespace App\Livewire\Front\Wishlist;

use App\Models\Wishlist;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithPagination;

class Listado extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $viewMode = 'grid';

    public function removeFromWishlist($wishlistId)
    {
        $wishlist = Wishlist::find($wishlistId);
        if ($wishlist && $wishlist->user_id === Auth::id()) {
            $wishlist->delete();
            
            $this->dispatch('alert', [
                'title' => '¡Eliminado!',
                'text' => 'Producto eliminado de favoritos',
                'icon' => 'success',
            ]);
            
            $this->dispatch('reloadWhislist');
        }
    }

    public function addToCart($productId)
    {
        $producto = \App\Models\Producto::find($productId);
        
        if ($producto) {
            \Cart::session(userID())->add([
                'id' => $producto->id,
                'name' => $producto->name,
                'price' => $producto->price,
                'quantity' => 1,
                'attributes' => [],
                'associatedModel' => $producto
            ]);

            $this->dispatch('alert', [
                'title' => '¡Agregado!',
                'text' => 'Producto agregado al carrito',
                'icon' => 'success',
            ]);
            
            $this->dispatch('reloadCartDetail');
        }
    }

    public function setViewMode($mode)
    {
        $this->viewMode = $mode;
    }

    public function render()
    {
        $wishlists = Wishlist::with(['producto.categoria', 'producto.marca', 'producto.image'])
            ->where('user_id', Auth::id())
            ->paginate(12);
            
        return view('livewire.front.wishlist.listado', compact('wishlists'))
            ->layout('layouts.front.app');
    }
}
