<?php

namespace App\Livewire\Front\Pedido;

use App\Models\Pedido;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Detalle extends Component
{
    public $pedido;
    public $codigo;

    public function mount($codigo)
    {
        $this->codigo = $codigo;
        $this->pedido = Pedido::with([
                'detalles.producto.images', 
                'detalles.variant',
                'referenciaBancaria.banco',
                'pagos'
            ])
            ->where('codigo', $codigo)
            ->where('userId', Auth::id())
            ->firstOrFail();
            
        // Debug: Verificar que los detalles tienen la información correcta
        \Log::info('Pedido cargado para detalle', [
            'pedido_id' => $this->pedido->id,
            'detalles_count' => $this->pedido->detalles->count(),
            'detalles_info' => $this->pedido->detalles->map(function($d) {
                return [
                    'id' => $d->id,
                    'product_name' => $d->product_name,
                    'variant_id' => $d->variant_id,
                    'producto_name' => $d->producto ? $d->producto->name : 'null',
                    'has_variant' => $d->variant ? true : false,
                    'table_name' => $d->getTable() // Para verificar qué tabla está usando
                ];
            })->toArray()
        ]);
    }

    public function render()
    {
        return view('livewire.front.pedido.detalle')
            ->layout('layouts.front.app');
    }
}