<?php

namespace App\Livewire\Front;

use Livewire\Component;
use Livewire\Attributes\On;
use Darryldecode\Cart\Facades\CartFacade as Cart;

class MiniCart extends Component
{
    public $cartItems = [];
    public $cartCount = 0;
    public $cartTotal = 0;
    public $currency = 'usd';

    public function mount()
    {
        $this->loadCart();
        $this->currency = (session()->has('currency')) ? session()->get('currency') : 'usd';

    }

    #[On('cartUpdated')]
    public function loadCart()
    {
        if (auth()->check()) {
            $this->cartItems = Cart::session(userID())->getContent()->sortBy('id') ?? collect();
            $this->cartCount = Cart::session(userID())->getTotalQuantity() ?? 0;
            $this->cartTotal = Cart::session(userID())->getTotal() ?? 0;
        } else {
            $this->cartItems = collect();
            $this->cartCount = 0;
            $this->cartTotal = 0;
        }
    }

    public function removeItem($id)
    {
        try {
            Cart::session(userID())->remove($id);
            $this->loadCart();
            $this->dispatch('cartUpdated');

            $this->dispatch('alert', [
                'title' => '¡Producto eliminado!',
                'text' => 'El producto ha sido eliminado del carrito',
                'icon' => 'success',
            ]);
        } catch (\Exception $e) {
            $this->dispatch('alert', [
                'title' => 'Error',
                'text' => 'No se pudo eliminar el producto del carrito',
                'icon' => 'error',
            ]);
        }
    }

    public function render()
    {
        return view('livewire.front.mini-cart');
    }
}
