<?php

namespace App\Livewire\Front;

use App\Models\Wishlist;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\On;
class Header extends Component
{
    public $fav = [];

    function mount()
    {
        $this->fav = \App\Models\Wishlist::where('user_id',Auth::id())->get();
    }

    public function render()
    {
        return view('livewire.front.header');
    }


    function removeWishlist($id)
    {
        Wishlist::find($id)->delete();
        $this->dispatch('reloadWhislist');
        $this->fav = \App\Models\Wishlist::where('user_id',Auth::id())->get();
    }

    #[On('reloadWhislistDetail')]
    public function reload()
   {
       $this->fav =  \App\Models\Wishlist::where('user_id',Auth::id())->get();

   }

   function logout()
   {


         Auth::logout();
        return redirect('front/store');

   }
}
