<?php

namespace App\Livewire\Components;

use Livewire\Component;

class ThemeToggle extends Component
{
    public $isDark = false;

    public function mount()
    {
        $this->isDark = session('theme', 'light') === 'dark';
    }

    public function toggleTheme()
    {
        $this->isDark = !$this->isDark;
        $theme = $this->isDark ? 'dark' : 'light';
        session(['theme' => $theme]);
        
        $this->dispatch('theme-changed', theme: $theme);
    }

    public function render()
    {
        return view('livewire.components.theme-toggle');
    }
}