<?php

namespace App\Livewire\Components;

use Livewire\Component;

class LazyImage extends Component
{
    public $src;
    public $alt;
    public $class;
    public $placeholder;
    
    public function mount($src, $alt = '', $class = '', $placeholder = null)
    {
        $this->src = $src;
        $this->alt = $alt;
        $this->class = $class;
        $this->placeholder = $placeholder ?? 'data:image/svg+xml;base64,' . base64_encode('<svg width="400" height="300" xmlns="http://www.w3.org/2000/svg"><rect width="100%" height="100%" fill="#f3f4f6"/><text x="50%" y="50%" text-anchor="middle" dy=".3em" fill="#9ca3af">Cargando...</text></svg>');
    }

    public function render()
    {
        return view('livewire.components.lazy-image');
    }
}