<?php

namespace App\Livewire\Admin\Ventas;

use App\Models\Venta;
use Livewire\Component;
use App\Traits\HasDynamicLayout;
use App\Traits\HasRegionalFormatting;

class Detalle extends Component
{
    use HasDynamicLayout, HasRegionalFormatting;

    public Venta $venta;

    public function mount(Venta $venta)
    {
        // Inicializar configuración regional
        $this->bootHasRegionalFormatting();

        $this->venta = $venta->load(['detalles.producto', 'detalles.variante', 'pagos', 'cliente', 'usuario', 'caja', 'serie']);
    }

    public function render()
    {
        return view('livewire.admin.ventas.detalle')->layout($this->getLayout());
    }
}