<?php

namespace App\Livewire\Admin\Users\Profile;

use App\Traits\HasDynamicLayout;
use Livewire\Component;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ChangePassword extends Component
{
    use HasDynamicLayout;

    public $current_password;
    public $password;
    public $password_confirmation;
    public $user;
    public $user_id;

    public function mount($user_id)
    {
        $this->user_id = $user_id;
        $this->user = User::findOrFail($user_id);
    }

    public function updatePassword()
    {
        $this->validate([
            'current_password' => 'required',
            'password' => 'required|min:8|confirmed',
        ]);

        if (!Hash::check($this->current_password, $this->user->password)) {
            $this->addError('current_password', 'La contraseña actual es incorrecta');
            return;
        }

        $this->user->update([
            'password' => Hash::make($this->password)
        ]);

        $this->reset(['current_password', 'password', 'password_confirmation']);
        
        $this->dispatch('alert', [
            'title' => '¡Actualizado!',
            'text' => 'Contraseña actualizada correctamente',
            'icon' => 'success'
        ]);
    }

    public function render()
    {
        return $this->renderWithLayout('livewire.admin.users.profile.password', [], [
            'title' => 'Cambiar Contraseña',
            'breadcrumb' => [
                'admin.dashboard' => 'Dashboard',
                'admin.users.profile' => 'Mi Perfil',
                'admin.users.password' => 'Cambiar Contraseña'
            ]
        ]);
    }
}




