<?php

namespace App\Livewire\Admin\Empleados;

use App\Models\Empleado;
use App\Models\Empresa;
use App\Models\Sucursal;
use App\Traits\HasDynamicLayout;
use Livewire\Component;

class Edit extends Component
{
    use HasDynamicLayout;
    
    public Empleado $empleado;
    public $codigo = '';
    public $nombres = '';
    public $apellidos = '';
    public $documento = '';
    public $tipo_documento = 'cedula';
    public $email = '';
    public $telefono = '';
    public $fecha_nacimiento = '';
    public $genero = '';
    public $direccion = '';
    public $cargo = '';
    public $departamento = '';
    public $salario = '';
    public $fecha_ingreso = '';
    public $fecha_salida = '';
    public $estado_civil = '';
    public $contacto_emergencia = '';
    public $telefono_emergencia = '';
    public $observaciones = '';
    public $status = true;
    public $empresa_id = '';
    public $sucursal_id = '';

    public function mount(Empleado $empleado)
    {
        $this->empleado = $empleado;
        $this->fill($empleado->toArray());
    }

    public function rules()
    {
        return [
            'nombres' => 'required|string|max:255',
            'apellidos' => 'required|string|max:255',
            'documento' => 'required|string|unique:empleados,documento,' . $this->empleado->id,
            'tipo_documento' => 'required|in:cedula,pasaporte,rif',
            'email' => 'required|email|unique:empleados,email,' . $this->empleado->id,
            'telefono' => 'required|string|max:20',
            'fecha_nacimiento' => 'nullable|date',
            'genero' => 'nullable|in:masculino,femenino,otro',
            'direccion' => 'nullable|string',
            'cargo' => 'required|string|max:255',
            'departamento' => 'required|string|max:255',
            'salario' => 'nullable|numeric|min:0',
            'fecha_ingreso' => 'required|date',
            'estado_civil' => 'nullable|in:soltero,casado,divorciado,viudo',
            'contacto_emergencia' => 'nullable|string|max:255',
            'telefono_emergencia' => 'nullable|string|max:20',
            'observaciones' => 'nullable|string',
            'empresa_id' => 'required|exists:empresas,id',
            'sucursal_id' => 'required|exists:sucursales,id'
        ];
    }

    public function update()
    {
        $this->validate();
        
        $this->empleado->update([
            'nombres' => $this->nombres,
            'apellidos' => $this->apellidos,
            'documento' => $this->documento,
            'tipo_documento' => $this->tipo_documento,
            'email' => $this->email,
            'telefono' => $this->telefono,
            'fecha_nacimiento' => $this->fecha_nacimiento,
            'genero' => $this->genero,
            'direccion' => $this->direccion,
            'cargo' => $this->cargo,
            'departamento' => $this->departamento,
            'salario' => $this->salario,
            'fecha_ingreso' => $this->fecha_ingreso,
            'estado_civil' => $this->estado_civil,
            'contacto_emergencia' => $this->contacto_emergencia,
            'telefono_emergencia' => $this->telefono_emergencia,
            'observaciones' => $this->observaciones,
            'status' => $this->status,
            'empresa_id' => $this->empresa_id,
            'sucursal_id' => $this->sucursal_id
        ]);

        session()->flash('message', 'Empleado actualizado exitosamente.');
        return redirect()->route('admin.empleados.index');
    }

    public function render()
    {
        $empresas = Empresa::all();
        $sucursales = $this->empresa_id ? Sucursal::where('empresa_id', $this->empresa_id)->get() : collect();

        return $this->renderWithLayout('livewire.admin.empleados.edit', compact('empresas', 'sucursales'));
    }
}