<?php

namespace App\Livewire\Admin\Categorias;

use App\Models\Categoria;
use Livewire\Component;
use App\Traits\HasDynamicLayout;

class Edit extends Component
{
    use HasDynamicLayout;

    public Categoria $categoria;
    public $nombre;
    public $descripcion;
    public $activo = true;

    protected $rules = [
        'nombre' => 'required|string|max:255|unique:categorias,nombre,{id}',
        'descripcion' => 'nullable|string|max:500',
        'activo' => 'boolean'
    ];

    public function mount(Categoria $categoria)
    {
        $this->categoria = $categoria;
        $this->nombre = $categoria->nombre;
        $this->descripcion = $categoria->descripcion;
        $this->activo = $categoria->activo;
    }

    public function save()
    {
        $this->rules['nombre'] = str_replace('{id}', $this->categoria->id, $this->rules['nombre']);
        $this->validate();

        $this->categoria->update([
            'nombre' => $this->nombre,
            'descripcion' => $this->descripcion,
            'activo' => $this->activo
        ]);

        $this->dispatch('notify', ['message' => 'Categoría actualizada correctamente.', 'type' => 'success']);
        return redirect()->route('admin.categorias.index');
    }

    public function render()
    {
        return $this->renderWithLayout('livewire.admin.categorias.edit',[
             'categoria' => $this->categoria,
          ], [
            'description' => 'Edición de categoría',
        ]);
    }
}
