<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class WhatsAppOptimization
{
    public function handle(Request $request, Closure $next)
    {
        // Configurar headers para optimizar la respuesta
        $response = $next($request);
        
        // Solo aplicar a rutas de WhatsApp
        if (str_contains($request->path(), 'whatsapp')) {
            $response->headers->set('Cache-Control', 'no-cache, must-revalidate');
            $response->headers->set('X-Accel-Buffering', 'no'); // Para Nginx
            $response->headers->set('Connection', 'keep-alive');
        }
        
        return $response;
    }
}