<?php

namespace App\Events;

use App\Models\Pedido;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PedidoActualizado implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $pedido;
    public $accion;

    public function __construct(Pedido $pedido, string $accion)
    {
        $this->pedido = $pedido->load(['user', 'empleados']);
        $this->accion = $accion;
    }

    public function broadcastOn()
    {
        return new Channel('pedidos');
    }

    public function broadcastWith()
    {
        return [
            'pedido' => [
                'id' => $this->pedido->id,
                'codigo' => $this->pedido->codigo,
                'estado' => $this->pedido->estado,
                'total_usd' => $this->pedido->total_usd,
                'cliente' => $this->pedido->user->name,
                'empleado' => $this->pedido->empleados->first()?->nombre_completo,
                'created_at' => $this->pedido->created_at->format('d/m/Y H:i')
            ],
            'accion' => $this->accion,
            'timestamp' => now()->toISOString()
        ];
    }
}