<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        Commands\ConvertIconsToRemixCommand::class,
        Commands\SendAccessNotificationJob::class,
        Commands\SendAutomaticNotificationsCommand::class,
        Commands\FetchExchangeRates::class,
        Commands\SeedProductosConVariantesCommand::class,
        Commands\GenerateApiTokensCommand::class,
        Commands\GenerateAdminApiTokensCommand::class,
        Commands\CleanupTempFiles::class,
        Commands\SetupApiCommand::class,
        Commands\TestWhatsAppCommand::class,
        \App\Console\Commands\CheckWhatsAppApiStatus::class,
        \App\Console\Commands\WhatsAppLogout::class,
        \App\Console\Commands\TestWhatsAppJWT::class,
        Commands\AutomatizarCajaTasa::class,
        Commands\ActualizarTasaProgramada::class,
        Commands\CorteCajaAutomatico::class,
        Commands\VerificarEstadoCajaTasa::class,
        Commands\ProbarCajaTasaSistema::class,
         Commands\SendAccessNotificationJob::class,
        Commands\ProcessWhatsAppScheduledMessages::class,
        Commands\RetryFailedWhatsAppMessages::class,
        Commands\ScheduleWhatsAppRetry::class,
        Commands\SetupWhatsAppAutoRetry::class,
        Commands\WhatsAppRetryStatus::class,
        Commands\DevRetryWhatsApp::class, // Comando de desarrollo
        Commands\TestStudentWhatsAppNotification::class, // Comando de prueba para
        Commands\ProcesarMensajesPendientes::class, // Procesar mensajes WhatsApp pendientes
        Commands\VerEstadoMensajesPendientes::class, // Ver estado de mensajes pendientes
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        $schedule->command('notifications:send-automatic')->dailyAt('08:00');

         $schedule->command('cleanup:temp-files --hours=1')->hourly();

        // Obtener tasas de cambio del BCV dos veces al día
        $schedule->command('exchange:fetch')
            ->dailyAt('10:00')
            ->timezone('America/Caracas');

        $schedule->command('exchange:fetch')
            ->dailyAt('14:00')
            ->timezone('America/Caracas');

        // Sincronizar sesiones WhatsApp cada 5 minutos
        $schedule->command('whatsapp:sync-sessions')->everyFiveMinutes();

        // Limpiar sesiones antiguas desconectadas (más de 30 días)
        $schedule->command('model:prune --model=App\Models\WhatsAppSession --days=30')->daily();

        // ===== NUEVAS AUTOMATIZACIONES DE CAJA Y TASA =====

        // Automatización completa cada 30 minutos para verificar condiciones
        $schedule->command('cajatasa:automatizar')
            ->everyThirtyMinutes()
            ->timezone('America/Caracas')
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/cajatasa-automation.log'));

        // Actualización automática de tasa a las 2:30 PM
        $schedule->command('tasa:actualizar-programada')
            ->dailyAt('14:30')
            ->timezone('America/Caracas')
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/tasa-programada.log'));

        // Corte de caja automático a las 1:00 PM
        $schedule->command('caja:corte-automatico')
            ->dailyAt('13:00')
            ->timezone('America/Caracas')
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/corte-caja-1pm.log'));

        // Corte de caja automático a las 6:00 PM
        $schedule->command('caja:corte-automatico')
            ->dailyAt('18:00')
            ->timezone('America/Caracas')
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/corte-caja-6pm.log'));

        // Verificación de tasa desde las 12:00 AM hasta las 2:00 PM cada hora
        $schedule->command('exchange:fetch')
            ->hourly()
            ->between('00:00', '14:00')
            ->timezone('America/Caracas')
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/tasa-verificacion.log'));

        // Procesar mensajes de WhatsApp pendientes cada 5 minutos
        $schedule->command('whatsapp:procesar-pendientes --max=20')
            ->everyFiveMinutes()
            ->withoutOverlapping()
            ->onOneServer()
            ->appendOutputTo(storage_path('logs/whatsapp-pendientes.log'));


        \Illuminate\Support\Facades\Schedule::job(new \App\Jobs\SendOrderWhatsAppNotification)->everyFiveMinutes();


        $schedule->command('queue:work --stop-when-empty')
         ->everyFiveMinutes()
         ->withoutOverlapping(); // Evita que se ejecuten dos al mismo tiempo


    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
