<?php

namespace App\Console\Commands;

use App\Services\WhatsAppService;
use Illuminate\Console\Command;

class WhatsAppLogout extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'whatsapp:logout';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cerrar sesión en la API de WhatsApp';

    /**
     * Execute the console command.
     */
    public function handle(WhatsAppService $whatsappService)
    {
        $this->info('Cerrando sesión en la API de WhatsApp...');
        
        $result = $whatsappService->logout();
        
        if ($result['success']) {
            $this->info('✓ ' . $result['message']);
        } else {
            $this->error('✗ Error al cerrar sesión en la API de WhatsApp:');
            $this->error($result['error']);
        }
    }
}