<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\WhatsAppService;

class TestWhatsAppDirecto extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:whatsapp-directo {phone}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Prueba directa de envío de WhatsApp con detalles completos';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $phone = $this->argument('phone');
        
        $this->info("=== PRUEBA DE ENVÍO DIRECTO DE WHATSAPP ===");
        $this->info("Teléfono: {$phone}");
        
        $whatsappService = new WhatsAppService();
        
        // Verificar el formato del número
        $this->info("Número original: {$phone}");
        $cleanPhone = $whatsappService->cleanPhoneNumber($phone);
        $this->info("Número formateado: {$cleanPhone}");
        
        // Crear mensaje de prueba
        $message = "🧪 *Mensaje de prueba directa*\n\n";
        $message .= "Esta es una prueba directa del servicio de WhatsApp.\n";
        $message .= "Hora: " . now()->format('Y-m-d H:i:s') . "\n";
        $message .= "Número: {$cleanPhone}\n";
        $message .= "ID único: " . uniqid();
        
        $this->info("\nMensaje a enviar:");
        $this->line($message);
        
        // Enviar mensaje
        $this->info("\n=== ENVIANDO MENSAJE ===");
        
        try {
            $result = $whatsappService->sendMessage($cleanPhone, $message);
            
            $this->info("=== RESULTADO ===");
            $this->info("Success: " . ($result['success'] ? '✅ Sí' : '❌ No'));
            
            if (isset($result['simulated'])) {
                $this->warn("Modo simulado: " . ($result['simulated'] ? 'Sí' : 'No'));
            }
            
            if (isset($result['message_id'])) {
                $this->info("Message ID: {$result['message_id']}");
            }
            
            if (isset($result['error'])) {
                $this->error("Error: {$result['error']}");
            }
            
            if (isset($result['details'])) {
                $this->line("Detalles: " . json_encode($result['details'], JSON_PRETTY_PRINT));
            }
            
            $this->line("Respuesta completa: " . json_encode($result, JSON_PRETTY_PRINT));
            
            // Verificar en logs de PM2
            $this->info("\n=== VERIFICANDO LOGS DE PM2 ===");
            exec('pm2 logs whatsapp --lines 5 --nostream', $output, $returnCode);
            if (!empty($output)) {
                foreach (array_slice($output, -5) as $line) {
                    if (strpos($line, '584242115948') !== false || strpos($line, 'Message sent') !== false) {
                        $this->line($line);
                    }
                }
            }
            
        } catch (\Exception $e) {
            $this->error("❌ ERROR: " . $e->getMessage());
            $this->error("Stack trace: " . $e->getTraceAsString());
        }
        
        $this->info("\n=== FIN DE PRUEBA ===");
        
        return Command::SUCCESS;
    }
}