<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\WhatsAppService;

class TestWhatsAppCommand extends Command
{
    protected $signature = 'whatsapp:test {--phone=+584121234567 : Número de teléfono de prueba} {--message="Mensaje de prueba desde el sistema" : Mensaje a enviar}';
    protected $description = 'Probar la conexión y envío de mensajes de WhatsApp';

    public function handle()
    {
        $phone = $this->option('phone');
        $message = $this->option('message');
        
        $this->info('🔄 Probando conexión WhatsApp...');
        $this->info("📱 Teléfono: {$phone}");
        $this->info("💬 Mensaje: {$message}");
        
        try {
            $whatsappService = new WhatsAppService();
            
            // Verificar configuración
            $this->info('⚙️ Verificando configuración...');
            
            $result = $whatsappService->sendMessage($phone, $message);
            
            if ($result['success']) {
                $this->info('✅ Mensaje enviado exitosamente');
                
                if (isset($result['simulated']) && $result['simulated']) {
                    $this->warn('⚠️ MODO SIMULADO: El mensaje no se envió realmente');
                    $this->info('💡 Para envío real, configura WHATSAPP_API_URL y WHATSAPP_API_TOKEN en .env');
                }
                
                if (isset($result['message_id'])) {
                    $this->info("🆔 ID del mensaje: {$result['message_id']}");
                }
                
                return 0;
            } else {
                $this->error('❌ Error al enviar mensaje: ' . ($result['error'] ?? 'Error desconocido'));
                return 1;
            }
            
        } catch (\Exception $e) {
            $this->error('💥 Excepción: ' . $e->getMessage());
            return 1;
        }
    }
}