<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class TestLocationAccuracy extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:location-accuracy {--lat=} {--lng=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Probar la geolocalización con precisión';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $lat = $this->option('lat');
        $lng = $this->option('lng');

        $this->info("Probando geolocalización para lat: {$lat}, lng: {$lng}");

        // Simular una precisión de 10 metros
        $accuracy = 10;

        // Probar reverse geocoding
        $this->info("Probando reverse geocoding...");

        // Usar Nominatim (OpenStreetMap) que es gratuito
        $url = "https://nominatim.openstreetmap.org/reverse?lat={$lat}&lon={$lng}&format=json&addressdetails=1";

        try {
            $response = Http::withHeaders([
                'User-Agent' => 'PedidosApp/1.0 (https://pedidos.test)'
            ])->get($url);

            if ($response->successful()) {
                $data = $response->json();
                $address = $data['display_name'] ?? "Coordenadas: {$lat}, {$lng}";

                $this->info("Dirección obtenida: {$address}");
                $this->info("Precisión simulada: {$accuracy} metros");

                // Guardar en sesión (simulado)
                session(['location_accuracy' => $accuracy]);
                $this->info("Precisión guardada en sesión: {$accuracy}");

                return Command::SUCCESS;
            } else {
                $this->error("Error en reverse geocoding: " . $response->status());
                return Command::FAILURE;
            }
        } catch (\Exception $e) {
            $this->error("Excepción: " . $e->getMessage());
            return Command::FAILURE;
        }
    }
}
