<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\Facades\JWTAuth;

class TestJWT extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:jwt {email}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Probar generación de token JWT';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = $this->argument('email');

        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->error('Usuario no encontrado');
            return 1;
        }

        try {
            // Intentar generar un token JWT
            $token = JWTAuth::fromUser($user);

            $this->info('Token JWT generado exitosamente:');
            $this->line($token);

            // Verificar el token
            $payload = JWTAuth::setToken($token)->getPayload();
            $this->info('Payload del token:');
            $this->line(json_encode($payload->toArray(), JSON_PRETTY_PRINT));

            return 0;
        } catch (\Exception $e) {
            $this->error('Error al generar token: ' . $e->getMessage());
            return 1;
        }
    }
}
