<?php

namespace App\Console\Commands;

use Database\Seeders\ProductosConVariantesSeeder;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class SeedProductosConVariantesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:productos-variants {--fresh : Ejecutar migrate:fresh antes de seedear}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Crear productos con variantes, categorías y marcas de ejemplo';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('🚀 Iniciando creación de productos con variantes...');

        // Opción de ejecutar migrate:fresh
        if ($this->option('fresh')) {
            $this->warn('⚠️  Ejecutando migrate:fresh... Esto eliminará todos los datos existentes.');
            if ($this->confirm('¿Estás seguro de que quieres continuar?')) {
                $this->call('migrate:fresh');
                $this->info('✅ Base de datos reiniciada exitosamente.');
            } else {
                $this->info('Operación cancelada.');
                return;
            }
        }

        try {
            // Verificar que existan las tablas necesarias
            $this->info('📋 Verificando estructura de base de datos...');

            // Ejecutar seeders necesarios en el orden correcto
            $this->info('🔑 Creando roles y permisos...');
            $this->call('db:seed', [
                '--class' => 'Database\Seeders\RolesAndPermissionsSeeder',
                '--force' => true,
            ]);


            $this->call('db:seed', [
                '--class' => 'Database\Seeders\PaisSeeder',
                '--force' => true,
            ]);

            $this->call('db:seed', [
                '--class' => 'Database\Seeders\EmpresaSeeder',
                '--force' => true,
            ]);

            $this->call('db:seed', [
                '--class' => 'Database\Seeders\SucursalSeeder',
                '--force' => true,
            ]);


            // Ejecutar seeders necesarios en el orden correcto
            $this->info('🔑 Creando las series...');
            $this->call('db:seed', [
                '--class' => 'Database\Seeders\SerieSeeder',
                '--force' => true,
            ]);

            // Ejecutar seeders necesarios en el orden correcto
            $this->info('🔑 Creando las TemplateCustomization...');
            $this->call('db:seed', [
                '--class' => 'Database\Seeders\TemplateCustomizationSeeder',
                '--force' => true,
            ]);

            // Ejecutar seeders necesarios en el orden correcto
            $this->info('🔑 Creando las Categorias...');
            $this->call('db:seed', [
                '--class' => 'Database\Seeders\CategoriaSeeder',
                '--force' => true,
            ]);


            // Ejecutar seeders necesarios en el orden correcto
            $this->info('🔑 Creando las Marcas...');
            $this->call('db:seed', [
                '--class' => 'Database\Seeders\MarcaSeeder',
                '--force' => true,
            ]);

            // Ejecutar seeders necesarios en el orden correcto
            $this->info('🔑 Creando los Usuarios...');
            $this->call('db:seed', [
                '--class' => 'Database\Seeders\UsersTableSeeder',
                '--force' => true,
            ]);




        } catch (\Exception $e) {
            $this->error('❌ Error al crear productos con variantes: ' . $e->getMessage());
            $this->error('📍 Archivo: ' . $e->getFile() . ' - Línea: ' . $e->getLine());
            return 1;
        }

        return 0;
    }
}
