<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\BatchService;

class MarkExpiredBatches extends Command
{
    protected $signature = 'batches:mark-expired';
    protected $description = 'Mark expired product batches and update their status';

    public function handle()
    {
        $batchService = new BatchService();
        $expiredCount = $batchService->markExpiredBatches();
        
        $this->info("Marcados {$expiredCount} lotes como vencidos.");
        
        return 0;
    }
}