<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Str;

class GenerateApiTokensCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'api:generate-tokens {--user= : ID del usuario específico}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generar tokens API para usuarios';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Generando tokens API...');

        // Obtener usuarios
        if ($this->option('user')) {
            $users = User::where('id', $this->option('user'))->get();
            if ($users->isEmpty()) {
                $this->error('Usuario no encontrado');
                return 1;
            }
        } else {
            $users = User::all();
        }

        $bar = $this->output->createProgressBar($users->count());
        $bar->start();

        foreach ($users as $user) {
            // Generar token único
            $token = Str::random(80);

            // Actualizar usuario
            $user->api_token = $token;
            $user->save();

            $this->info("\nToken generado para {$user->name} ({$user->email}): {$token}");
            $bar->advance();
        }

        $bar->finish();
        $this->info("\n\nTokens API generados exitosamente para {$users->count()} usuarios.");

        return 0;
    }
}
