<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\WhatsAppService;

class DebugWhatsAppStatus extends Command
{
    protected $signature = 'whatsapp:debug-status';
    protected $description = 'Depurar el estado del servicio de WhatsApp';

    public function handle()
    {
        $this->info('=== Depurando WhatsApp Service ===');
        
        // Crear instancia del servicio
        $whatsappService = new WhatsAppService();
        
        $this->info('1. Probando testConnection():');
        $connection = $whatsappService->testConnection();
        $this->line(json_encode($connection, JSON_PRETTY_PRINT));
        $this->newLine();
        
        $this->info('2. Probando getStatus():');
        $status = $whatsappService->getStatus();
        $this->line(json_encode($status, JSON_PRETTY_PRINT));
        $this->newLine();
        
        $this->info('3. Probando getDetailedStatus():');
        $detailedStatus = $whatsappService->getDetailedStatus();
        $this->line(json_encode($detailedStatus, JSON_PRETTY_PRINT));
        $this->newLine();
        
        $this->info('4. Probando getQueueStats():');
        $queueStats = $whatsappService->getQueueStats();
        $this->line(json_encode($queueStats, JSON_PRETTY_PRINT));
        $this->newLine();
        
        $this->info('5. Probando getDailyStats():');
        $dailyStats = $whatsappService->getDailyStats();
        $this->line(json_encode($dailyStats, JSON_PRETTY_PRINT));
        $this->newLine();
        
        $this->info('=== Análisis del problema ===');
        
        // Verificar si getStatus retorna null o array vacío
        if ($status === null) {
            $this->error('❌ getStatus() retorna NULL');
        } elseif (is_array($status) && empty($status)) {
            $this->error('❌ getStatus() retorna array vacío');
        } elseif (isset($status['success']) && $status['success'] === false) {
            $this->error('❌ getStatus() retorna error: ' . ($status['error'] ?? 'Error desconocido'));
        } else {
            $this->info('✅ getStatus() retorna datos válidos');
        }
        
        $this->info('=== Fin de la depuración ===');
        
        return Command::SUCCESS;
    }
}