<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Livewire\Admin\WhatsApp\Dashboard;

class DebugDashboardComponent extends Command
{
    protected $signature = 'whatsapp:debug-dashboard';
    protected $description = 'Depurar el componente Dashboard de WhatsApp';

    public function handle()
    {
        $this->info('=== Depurando Componente Dashboard ===');
        
        // Crear instancia del componente
        $dashboard = new Dashboard();
        
        $this->info('1. Estado inicial del componente:');
        $this->line('connectionStatus: ' . $dashboard->connectionStatus);
        $this->line('isReady: ' . ($dashboard->isReady ? 'true' : 'false'));
        $this->line('qrCode: ' . ($dashboard->qrCode ? 'presente' : 'null'));
        $this->line('isChecking: ' . ($dashboard->isChecking ? 'true' : 'false'));
        $this->newLine();
        
        $this->info('2. Ejecutando checkStatus()...');
        
        // Capturar el resultado de checkStatus
        ob_start();
        $dashboard->checkStatus();
        $output = ob_get_clean();
        
        $this->info('3. Estado después de checkStatus():');
        $this->line('connectionStatus: ' . $dashboard->connectionStatus);
        $this->line('isReady: ' . ($dashboard->isReady ? 'true' : 'false'));
        $this->line('qrCode: ' . ($dashboard->qrCode ? 'presente' : 'null'));
        $this->line('isChecking: ' . ($dashboard->isChecking ? 'true' : 'false'));
        $this->newLine();
        
        $this->info('4. Estadísticas de cola:');
        $this->line('messageQueueStats: ' . json_encode($dashboard->messageQueueStats));
        $this->newLine();
        
        $this->info('5. Estadísticas diarias:');
        $this->line('dailyStats: ' . json_encode($dashboard->dailyStats));
        $this->newLine();
        
        $this->info('6. Estado detallado:');
        $this->line('detailedStatus: ' . json_encode($dashboard->detailedStatus));
        $this->newLine();
        
        if ($output) {
            $this->info('7. Salida capturada:');
            $this->line($output);
        }
        
        $this->info('=== Fin de la depuración ===');
        
        return Command::SUCCESS;
    }
}