<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class CleanupTempFiles extends Command
{
    protected $signature = 'cleanup:temp-files {--hours=24 : Eliminar archivos más antiguos de X horas} {--force : Eliminar todos los archivos sin importar la fecha}';
    protected $description = 'Limpiar archivos temporales de Livewire antiguos';

    public function handle()
    {
        $hours = $this->option('hours');
        $force = $this->option('force');
        $tempDirs = [
            public_path('app/livewire-tmp'),
            public_path('app/livewire-temp')
        ];
        
        $totalDeleted = 0;
        $cutoffTime = $force ? PHP_INT_MAX : now()->subHours($hours)->timestamp;

        foreach ($tempDirs as $tempDir) {
            if (!is_dir($tempDir)) {
                continue;
            }

            $files = File::allFiles($tempDir);
            $deletedCount = 0;

            foreach ($files as $file) {
                if ($force || $file->getMTime() < $cutoffTime) {
                    File::delete($file->getPathname());
                    $deletedCount++;
                }
            }
            
            $totalDeleted += $deletedCount;
            if ($deletedCount > 0) {
                $this->info("Eliminados {$deletedCount} archivos de {$tempDir}");
            }
        }

        $message = $force ? 
            "Total eliminados: {$totalDeleted} archivos temporales (forzado)." :
            "Total eliminados: {$totalDeleted} archivos temporales más antiguos de {$hours} horas.";
        
        $this->info($message);
    }
}