<?php

namespace App\Console\Commands;

use App\Services\WhatsAppService;
use Illuminate\Console\Command;

class CheckWhatsAppApiStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'whatsapp:status';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verificar el estado de la API de WhatsApp';

    /**
     * Execute the console command.
     */
    public function handle(WhatsAppService $whatsappService)
    {
        $this->info('Verificando estado de la API de WhatsApp...');
        
        $result = $whatsappService->getStatus();
        
        if ($result['success']) {
            $message = $result['message'] ?? 'API conectada exitosamente';
            $status = $result['status'] ?? 'connected';
            $this->info('✓ API de WhatsApp: ' . $message);
            $this->info('Estado: ' . $status);
            
            // Mostrar información JWT si está disponible
            if (isset($result['jwt_authenticated']) && $result['jwt_authenticated']) {
                $this->info('✓ Autenticación JWT: Activa');
                if (isset($result['jwt_user'])) {
                    $this->info('Usuario JWT: ' . $result['jwt_user']['name'] . ' (' . $result['jwt_user']['email'] . ')');
                }
            }
        } else {
            $this->error('✗ Error al conectar con la API de WhatsApp:');
            $this->error($result['error']);
        }
    }
}